/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.internal;

import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.service.Shape;
import com.amazonaws.codegen.model.service.ShapeTypes;
import com.amazonaws.codegen.naming.NamingStrategy;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeUtils {
    public static final String LIST_INTERFACE = "listInterface";
    public static final String LIST_DEFAULT_IMPL = "listDefaultImpl";
    public static final String LIST_AUTO_CONSTRUCT_IMPL = "listAutoConstructImpl";
    public static final String MAP_INTERFACE = "mapInterface";
    public static final String MAP_DEFAULT_IMPL = "mapDefaultImpl";
    public static final String MAP_AUTO_CONSTRUCT_IMPL = "mapAutoConstructImpl";
    private static final Map<String, String> dataTypeMappings = new HashMap<String, String>();
    private static final Map<String, String> marshallingTypeMappings = new HashMap<String, String>();
    private final NamingStrategy namingStrategy;

    public TypeUtils(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public static String getMarshallingType(String simpleType) {
        return marshallingTypeMappings.get(simpleType);
    }

    public static boolean isSimple(String type) {
        return dataTypeMappings.containsKey(type) || dataTypeMappings.containsValue(type);
    }

    public static String getDataTypeMapping(String type) {
        return dataTypeMappings.get(type);
    }

    public String getJavaDataType(Map<String, Shape> shapes, String shapeName) {
        return this.getJavaDataType(shapes, shapeName, null);
    }

    public String getJavaDataType(Map<String, Shape> shapes, String shapeName, CustomizationConfig customConfig) {
        if (shapeName == null || shapeName.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot derive shape type. Shape name cannot be null or empty");
        }
        Shape shape = shapes.get(shapeName);
        if (shape == null) {
            throw new IllegalArgumentException("Cannot derive shape type. No shape information available for " + shapeName);
        }
        String shapeType = shape.getType();
        if (ShapeTypes.Structure.getName().equals(shapeType)) {
            return this.namingStrategy.getJavaClassName(shapeName);
        }
        if (ShapeTypes.List.getName().equals(shapeType)) {
            String listType = customConfig != null && customConfig.isUseAutoConstructList() ? LIST_AUTO_CONSTRUCT_IMPL : LIST_INTERFACE;
            String listContainerType = dataTypeMappings.get(listType);
            return listContainerType + "<" + this.getJavaDataType(shapes, shape.getListMember().getShape()) + ">";
        }
        if (ShapeTypes.Map.getName().equals(shapeType)) {
            String mapType = customConfig != null && customConfig.isUseAutoConstructMap() ? MAP_AUTO_CONSTRUCT_IMPL : MAP_INTERFACE;
            String mapContainerType = dataTypeMappings.get(mapType);
            return mapContainerType + "<" + this.getJavaDataType(shapes, shape.getMapKeyType().getShape()) + "," + this.getJavaDataType(shapes, shape.getMapValueType().getShape()) + ">";
        }
        if (shape.isStreaming()) {
            return dataTypeMappings.get("stream");
        }
        String dataType = dataTypeMappings.get(shapeType);
        if (dataType == null) {
            throw new RuntimeException("Equivalent Java data type cannot be found for data type : " + shapeType);
        }
        return dataType;
    }

    static {
        dataTypeMappings.put("string", String.class.getSimpleName());
        dataTypeMappings.put("boolean", Boolean.class.getSimpleName());
        dataTypeMappings.put("int", Integer.class.getSimpleName());
        dataTypeMappings.put("any", Object.class.getSimpleName());
        dataTypeMappings.put("integer", Integer.class.getSimpleName());
        dataTypeMappings.put("double", Double.class.getSimpleName());
        dataTypeMappings.put("short", Short.class.getSimpleName());
        dataTypeMappings.put("long", Long.class.getSimpleName());
        dataTypeMappings.put("float", Float.class.getSimpleName());
        dataTypeMappings.put("byte", Byte.class.getSimpleName());
        dataTypeMappings.put("timestamp", Date.class.getName());
        dataTypeMappings.put("blob", ByteBuffer.class.getName());
        dataTypeMappings.put("stream", InputStream.class.getName());
        dataTypeMappings.put("bigdecimal", BigDecimal.class.getName());
        dataTypeMappings.put("biginteger", BigInteger.class.getName());
        dataTypeMappings.put("list", List.class.getSimpleName());
        dataTypeMappings.put("map", Map.class.getSimpleName());
        dataTypeMappings.put(LIST_INTERFACE, List.class.getName());
        dataTypeMappings.put(LIST_DEFAULT_IMPL, ArrayList.class.getName());
        dataTypeMappings.put(LIST_AUTO_CONSTRUCT_IMPL, SdkInternalList.class.getName());
        dataTypeMappings.put(MAP_INTERFACE, Map.class.getName());
        dataTypeMappings.put(MAP_DEFAULT_IMPL, HashMap.class.getName());
        dataTypeMappings.put(MAP_AUTO_CONSTRUCT_IMPL, SdkInternalMap.class.getName());
        dataTypeMappings.put(LIST_INTERFACE, List.class.getName());
        dataTypeMappings.put(LIST_DEFAULT_IMPL, ArrayList.class.getName());
        dataTypeMappings.put(LIST_AUTO_CONSTRUCT_IMPL, SdkInternalList.class.getName());
        dataTypeMappings.put(MAP_INTERFACE, Map.class.getName());
        dataTypeMappings.put(MAP_DEFAULT_IMPL, HashMap.class.getName());
        dataTypeMappings.put(MAP_AUTO_CONSTRUCT_IMPL, SdkInternalMap.class.getName());
        marshallingTypeMappings.put("String", "STRING");
        marshallingTypeMappings.put("Integer", "INTEGER");
        marshallingTypeMappings.put("Long", "LONG");
        marshallingTypeMappings.put("Float", "FLOAT");
        marshallingTypeMappings.put("Double", "DOUBLE");
        marshallingTypeMappings.put("Date", "DATE");
        marshallingTypeMappings.put("ByteBuffer", "BYTE_BUFFER");
        marshallingTypeMappings.put("Boolean", "BOOLEAN");
        marshallingTypeMappings.put("BigDecimal", "BIG_DECIMAL");
        marshallingTypeMappings.put("InputStream", "STREAM");
        marshallingTypeMappings.put(null, "NULL");
    }
}

