/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.internal;

import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class NameUtils {
    private static final List<String> reservedKeywords = new ArrayList<String>();

    public static String getExceptionName(String exception) {
        if (exception.endsWith("Fault")) {
            return Utils.capitialize(exception.substring(0, exception.length() - "Fault".length()) + "Exception");
        }
        if (exception.endsWith("Exception")) {
            return Utils.capitialize(exception);
        }
        return Utils.capitialize(exception + "Exception");
    }

    public static String getRequestClassName(String shapeName, String operation) {
        return Utils.capitialize(operation + "Request");
    }

    public static String getResponseClassName(String shapeName, String operation) {
        return Utils.capitialize(operation + "Result");
    }

    public static String getVariableName(String name) {
        if (NameUtils.isJavaKeyword(name)) {
            return Utils.unCapitialize(name + "Value");
        }
        return Utils.unCapitialize(name);
    }

    public static String getEnumName(String name) {
        StringBuilder builder = new StringBuilder();
        String sanitizedEnumValue = name.replace("::", ":").replace("/", "").replace("(", "").replace(")", "");
        for (String part : sanitizedEnumValue.split("[ -.:]")) {
            if (part.length() > 1) {
                builder.append(StringUtils.upperCase((String)part.substring(0, 1))).append(part.substring(1));
                continue;
            }
            builder.append(StringUtils.upperCase((String)part));
        }
        return builder.toString();
    }

    public static String getJavaClassName(String name) {
        return Utils.capitialize(name);
    }

    public static boolean isJavaKeyword(String word) {
        return reservedKeywords.contains(word) || reservedKeywords.contains(StringUtils.lowerCase((String)word));
    }

    static {
        reservedKeywords.add("return");
        reservedKeywords.add("public");
        reservedKeywords.add("private");
        reservedKeywords.add("class");
        reservedKeywords.add("static");
        reservedKeywords.add("protected");
        reservedKeywords.add("return");
        reservedKeywords.add("string");
        reservedKeywords.add("boolean");
        reservedKeywords.add("integer");
        reservedKeywords.add("int");
        reservedKeywords.add("char");
        reservedKeywords.add("null");
        reservedKeywords.add("double");
        reservedKeywords.add("object");
        reservedKeywords.add("short");
        reservedKeywords.add("long");
        reservedKeywords.add("float");
        reservedKeywords.add("byte");
        reservedKeywords.add("bigDecimal");
        reservedKeywords.add("bigInteger");
        reservedKeywords.add("protected");
        reservedKeywords.add("inputStream");
        reservedKeywords.add("bytebuffer");
        reservedKeywords.add("date");
        reservedKeywords.add("list");
        reservedKeywords.add("map");
    }
}

