/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.model.config;

import com.fasterxml.jackson.annotation.JsonProperty;

public class BasicCodeGenConfig {
    private static final String PACKAGE_PREFIX = "com.amazonaws.services.";
    private final String interfaceName;
    private final String packageName;
    private final String endPoint;

    public BasicCodeGenConfig(@JsonProperty(value="serviceInterfaceName", required=true) String interfaceName, @Deprecated @JsonProperty(value="sourcePackageName") String packageName, @JsonProperty(value="packageSuffix") String packageSuffix, @JsonProperty(value="defaultEndpoint", required=true) String endpoint) {
        this.interfaceName = interfaceName;
        if (packageName != null) {
            if (packageSuffix != null) {
                throw new IllegalArgumentException("Both packageName and packageSuffix supplied!");
            }
            this.packageName = packageName;
        } else if (packageSuffix != null) {
            this.packageName = PACKAGE_PREFIX + packageSuffix;
        } else {
            String name = interfaceName;
            if (name.startsWith("Amazon")) {
                name = name.substring(6);
            } else if (name.startsWith("AWS")) {
                name = name.substring(3);
            }
            this.packageName = PACKAGE_PREFIX + name.toLowerCase();
        }
        this.endPoint = endpoint;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getEndpoint() {
        return this.endPoint;
    }
}

