/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchrum.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchrum.model.QueryFilter;
import com.amazonaws.services.cloudwatchrum.model.TimeRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetAppMonitorDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<QueryFilter> filters;
    private Integer maxResults;
    private String name;
    private String nextToken;
    private TimeRange timeRange;

    public List<QueryFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<QueryFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<QueryFilter>(filters);
    }

    public GetAppMonitorDataRequest withFilters(QueryFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<QueryFilter>(filters.length));
        }
        for (QueryFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public GetAppMonitorDataRequest withFilters(Collection<QueryFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetAppMonitorDataRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GetAppMonitorDataRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetAppMonitorDataRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public GetAppMonitorDataRequest withTimeRange(TimeRange timeRange) {
        this.setTimeRange(timeRange);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTimeRange() != null) {
            sb.append("TimeRange: ").append(this.getTimeRange());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppMonitorDataRequest)) {
            return false;
        }
        GetAppMonitorDataRequest other = (GetAppMonitorDataRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTimeRange() == null ^ this.getTimeRange() == null) {
            return false;
        }
        return other.getTimeRange() == null || other.getTimeRange().equals(this.getTimeRange());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTimeRange() == null ? 0 : this.getTimeRange().hashCode());
        return hashCode;
    }

    public GetAppMonitorDataRequest clone() {
        return (GetAppMonitorDataRequest)super.clone();
    }
}

