/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.AlarmHistoryItem;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class AlarmHistoryItemMarshaller {
    private static final MarshallingInfo<String> ALARMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmName").build();
    private static final MarshallingInfo<String> ALARMCONTRIBUTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmContributorId").build();
    private static final MarshallingInfo<String> ALARMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmType").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> HISTORYITEMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HistoryItemType").build();
    private static final MarshallingInfo<String> HISTORYSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HistorySummary").build();
    private static final MarshallingInfo<String> HISTORYDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HistoryData").build();
    private static final MarshallingInfo<Map> ALARMCONTRIBUTORATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmContributorAttributes").build();
    private static final AlarmHistoryItemMarshaller instance = new AlarmHistoryItemMarshaller();

    public static AlarmHistoryItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(AlarmHistoryItem alarmHistoryItem, ProtocolMarshaller protocolMarshaller) {
        if (alarmHistoryItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)alarmHistoryItem.getAlarmName(), ALARMNAME_BINDING);
            protocolMarshaller.marshall((Object)alarmHistoryItem.getAlarmContributorId(), ALARMCONTRIBUTORID_BINDING);
            protocolMarshaller.marshall((Object)alarmHistoryItem.getAlarmType(), ALARMTYPE_BINDING);
            protocolMarshaller.marshall((Object)alarmHistoryItem.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)alarmHistoryItem.getHistoryItemType(), HISTORYITEMTYPE_BINDING);
            protocolMarshaller.marshall((Object)alarmHistoryItem.getHistorySummary(), HISTORYSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)alarmHistoryItem.getHistoryData(), HISTORYDATA_BINDING);
            protocolMarshaller.marshall(alarmHistoryItem.getAlarmContributorAttributes(), ALARMCONTRIBUTORATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

