/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class MetricStreamFilter
implements Serializable,
Cloneable {
    private String namespace;
    private SdkInternalList<String> metricNames;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MetricStreamFilter withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public List<String> getMetricNames() {
        if (this.metricNames == null) {
            this.metricNames = new SdkInternalList();
        }
        return this.metricNames;
    }

    public void setMetricNames(Collection<String> metricNames) {
        if (metricNames == null) {
            this.metricNames = null;
            return;
        }
        this.metricNames = new SdkInternalList(metricNames);
    }

    public MetricStreamFilter withMetricNames(String ... metricNames) {
        if (this.metricNames == null) {
            this.setMetricNames((Collection<String>)new SdkInternalList(metricNames.length));
        }
        for (String ele : metricNames) {
            this.metricNames.add((Object)ele);
        }
        return this;
    }

    public MetricStreamFilter withMetricNames(Collection<String> metricNames) {
        this.setMetricNames(metricNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getMetricNames() != null) {
            sb.append("MetricNames: ").append(this.getMetricNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStreamFilter)) {
            return false;
        }
        MetricStreamFilter other = (MetricStreamFilter)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricNames() == null ^ this.getMetricNames() == null) {
            return false;
        }
        return other.getMetricNames() == null || other.getMetricNames().equals(this.getMetricNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricNames() == null ? 0 : this.getMetricNames().hashCode());
        return hashCode;
    }

    public MetricStreamFilter clone() {
        try {
            return (MetricStreamFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

