/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.MetricStreamFilter;
import com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsConfiguration;
import com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsMetric;
import com.amazonaws.services.cloudwatch.model.PutMetricStreamRequest;
import com.amazonaws.services.cloudwatch.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutMetricStreamRequestMarshaller
implements Marshaller<Request<PutMetricStreamRequest>, PutMetricStreamRequest> {
    public Request<PutMetricStreamRequest> marshall(PutMetricStreamRequest putMetricStreamRequest) {
        if (putMetricStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricStreamRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricStream");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricStreamRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)putMetricStreamRequest.getName()));
        }
        if (!putMetricStreamRequest.getIncludeFilters().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getIncludeFilters()).isAutoConstruct()) {
            SdkInternalList includeFiltersList = (SdkInternalList)putMetricStreamRequest.getIncludeFilters();
            int includeFiltersListIndex = 1;
            for (MetricStreamFilter includeFiltersListValue : includeFiltersList) {
                if (includeFiltersListValue != null && includeFiltersListValue.getNamespace() != null) {
                    request.addParameter("IncludeFilters.member." + includeFiltersListIndex + ".Namespace", StringUtils.fromString((String)includeFiltersListValue.getNamespace()));
                }
                ++includeFiltersListIndex;
            }
        }
        if (!putMetricStreamRequest.getExcludeFilters().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getExcludeFilters()).isAutoConstruct()) {
            SdkInternalList excludeFiltersList = (SdkInternalList)putMetricStreamRequest.getExcludeFilters();
            int excludeFiltersListIndex = 1;
            for (MetricStreamFilter excludeFiltersListValue : excludeFiltersList) {
                if (excludeFiltersListValue != null && excludeFiltersListValue.getNamespace() != null) {
                    request.addParameter("ExcludeFilters.member." + excludeFiltersListIndex + ".Namespace", StringUtils.fromString((String)excludeFiltersListValue.getNamespace()));
                }
                ++excludeFiltersListIndex;
            }
        }
        if (putMetricStreamRequest.getFirehoseArn() != null) {
            request.addParameter("FirehoseArn", StringUtils.fromString((String)putMetricStreamRequest.getFirehoseArn()));
        }
        if (putMetricStreamRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)putMetricStreamRequest.getRoleArn()));
        }
        if (putMetricStreamRequest.getOutputFormat() != null) {
            request.addParameter("OutputFormat", StringUtils.fromString((String)putMetricStreamRequest.getOutputFormat()));
        }
        if (!putMetricStreamRequest.getTags().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putMetricStreamRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (!putMetricStreamRequest.getStatisticsConfigurations().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getStatisticsConfigurations()).isAutoConstruct()) {
            SdkInternalList statisticsConfigurationsList = (SdkInternalList)putMetricStreamRequest.getStatisticsConfigurations();
            int statisticsConfigurationsListIndex = 1;
            for (MetricStreamStatisticsConfiguration statisticsConfigurationsListValue : statisticsConfigurationsList) {
                if (statisticsConfigurationsListValue != null) {
                    if (!statisticsConfigurationsListValue.getIncludeMetrics().isEmpty() || !((SdkInternalList)statisticsConfigurationsListValue.getIncludeMetrics()).isAutoConstruct()) {
                        SdkInternalList includeMetricsList = (SdkInternalList)statisticsConfigurationsListValue.getIncludeMetrics();
                        int includeMetricsListIndex = 1;
                        for (MetricStreamStatisticsMetric includeMetricsListValue : includeMetricsList) {
                            if (includeMetricsListValue != null) {
                                if (includeMetricsListValue.getNamespace() != null) {
                                    request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".IncludeMetrics.member." + includeMetricsListIndex + ".Namespace", StringUtils.fromString((String)includeMetricsListValue.getNamespace()));
                                }
                                if (includeMetricsListValue.getMetricName() != null) {
                                    request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".IncludeMetrics.member." + includeMetricsListIndex + ".MetricName", StringUtils.fromString((String)includeMetricsListValue.getMetricName()));
                                }
                            }
                            ++includeMetricsListIndex;
                        }
                    }
                    if (!statisticsConfigurationsListValue.getAdditionalStatistics().isEmpty() || !((SdkInternalList)statisticsConfigurationsListValue.getAdditionalStatistics()).isAutoConstruct()) {
                        SdkInternalList additionalStatisticsList = (SdkInternalList)statisticsConfigurationsListValue.getAdditionalStatistics();
                        int additionalStatisticsListIndex = 1;
                        for (String additionalStatisticsListValue : additionalStatisticsList) {
                            if (additionalStatisticsListValue != null) {
                                request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".AdditionalStatistics.member." + additionalStatisticsListIndex, StringUtils.fromString((String)additionalStatisticsListValue));
                            }
                            ++additionalStatisticsListIndex;
                        }
                    }
                }
                ++statisticsConfigurationsListIndex;
            }
        }
        return request;
    }
}

