/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudtrail.model.ImportSource;

@SdkInternalApi
public class ImportSourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3").build();
    private static final ImportSourceMarshaller instance = new ImportSourceMarshaller();

    public static ImportSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImportSource importSource, ProtocolMarshaller protocolMarshaller) {
        if (importSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importSource.getS3(), S3_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

