/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudtrail.AWSCloudTrailAsync;
import com.amazonaws.services.cloudtrail.AWSCloudTrailClient;
import com.amazonaws.services.cloudtrail.model.AddTagsRequest;
import com.amazonaws.services.cloudtrail.model.AddTagsResult;
import com.amazonaws.services.cloudtrail.model.CreateTrailRequest;
import com.amazonaws.services.cloudtrail.model.CreateTrailResult;
import com.amazonaws.services.cloudtrail.model.DeleteTrailRequest;
import com.amazonaws.services.cloudtrail.model.DeleteTrailResult;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsResult;
import com.amazonaws.services.cloudtrail.model.GetEventSelectorsRequest;
import com.amazonaws.services.cloudtrail.model.GetEventSelectorsResult;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusRequest;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusResult;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysRequest;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysResult;
import com.amazonaws.services.cloudtrail.model.ListTagsRequest;
import com.amazonaws.services.cloudtrail.model.ListTagsResult;
import com.amazonaws.services.cloudtrail.model.LookupEventsRequest;
import com.amazonaws.services.cloudtrail.model.LookupEventsResult;
import com.amazonaws.services.cloudtrail.model.PutEventSelectorsRequest;
import com.amazonaws.services.cloudtrail.model.PutEventSelectorsResult;
import com.amazonaws.services.cloudtrail.model.RemoveTagsRequest;
import com.amazonaws.services.cloudtrail.model.RemoveTagsResult;
import com.amazonaws.services.cloudtrail.model.StartLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StartLoggingResult;
import com.amazonaws.services.cloudtrail.model.StopLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StopLoggingResult;
import com.amazonaws.services.cloudtrail.model.UpdateTrailRequest;
import com.amazonaws.services.cloudtrail.model.UpdateTrailResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCloudTrailAsyncClient
extends AWSCloudTrailClient
implements AWSCloudTrailAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCloudTrailAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AWSCloudTrailAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCloudTrailAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCloudTrailAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSCloudTrailAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCloudTrailAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCloudTrailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCloudTrailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSCloudTrailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSCloudTrailAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(final AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.addTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrailResult> createTrailAsync(CreateTrailRequest request) {
        return this.createTrailAsync(request, null);
    }

    @Override
    public Future<CreateTrailResult> createTrailAsync(final CreateTrailRequest request, final AsyncHandler<CreateTrailRequest, CreateTrailResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTrailResult>(){

            @Override
            public CreateTrailResult call() throws Exception {
                CreateTrailResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.createTrail(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTrailResult> deleteTrailAsync(DeleteTrailRequest request) {
        return this.deleteTrailAsync(request, null);
    }

    @Override
    public Future<DeleteTrailResult> deleteTrailAsync(final DeleteTrailRequest request, final AsyncHandler<DeleteTrailRequest, DeleteTrailResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTrailResult>(){

            @Override
            public DeleteTrailResult call() throws Exception {
                DeleteTrailResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.deleteTrail(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrailsResult> describeTrailsAsync(DescribeTrailsRequest request) {
        return this.describeTrailsAsync(request, null);
    }

    @Override
    public Future<DescribeTrailsResult> describeTrailsAsync(final DescribeTrailsRequest request, final AsyncHandler<DescribeTrailsRequest, DescribeTrailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTrailsResult>(){

            @Override
            public DescribeTrailsResult call() throws Exception {
                DescribeTrailsResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.describeTrails(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrailsResult> describeTrailsAsync() {
        return this.describeTrailsAsync(new DescribeTrailsRequest());
    }

    @Override
    public Future<DescribeTrailsResult> describeTrailsAsync(AsyncHandler<DescribeTrailsRequest, DescribeTrailsResult> asyncHandler) {
        return this.describeTrailsAsync(new DescribeTrailsRequest(), asyncHandler);
    }

    @Override
    public Future<GetEventSelectorsResult> getEventSelectorsAsync(GetEventSelectorsRequest request) {
        return this.getEventSelectorsAsync(request, null);
    }

    @Override
    public Future<GetEventSelectorsResult> getEventSelectorsAsync(final GetEventSelectorsRequest request, final AsyncHandler<GetEventSelectorsRequest, GetEventSelectorsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetEventSelectorsResult>(){

            @Override
            public GetEventSelectorsResult call() throws Exception {
                GetEventSelectorsResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.getEventSelectors(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTrailStatusResult> getTrailStatusAsync(GetTrailStatusRequest request) {
        return this.getTrailStatusAsync(request, null);
    }

    @Override
    public Future<GetTrailStatusResult> getTrailStatusAsync(final GetTrailStatusRequest request, final AsyncHandler<GetTrailStatusRequest, GetTrailStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTrailStatusResult>(){

            @Override
            public GetTrailStatusResult call() throws Exception {
                GetTrailStatusResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.getTrailStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPublicKeysResult> listPublicKeysAsync(ListPublicKeysRequest request) {
        return this.listPublicKeysAsync(request, null);
    }

    @Override
    public Future<ListPublicKeysResult> listPublicKeysAsync(final ListPublicKeysRequest request, final AsyncHandler<ListPublicKeysRequest, ListPublicKeysResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPublicKeysResult>(){

            @Override
            public ListPublicKeysResult call() throws Exception {
                ListPublicKeysResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.listPublicKeys(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPublicKeysResult> listPublicKeysAsync() {
        return this.listPublicKeysAsync(new ListPublicKeysRequest());
    }

    @Override
    public Future<ListPublicKeysResult> listPublicKeysAsync(AsyncHandler<ListPublicKeysRequest, ListPublicKeysResult> asyncHandler) {
        return this.listPublicKeysAsync(new ListPublicKeysRequest(), asyncHandler);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request) {
        return this.listTagsAsync(request, null);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(final ListTagsRequest request, final AsyncHandler<ListTagsRequest, ListTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsResult>(){

            @Override
            public ListTagsResult call() throws Exception {
                ListTagsResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.listTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LookupEventsResult> lookupEventsAsync(LookupEventsRequest request) {
        return this.lookupEventsAsync(request, null);
    }

    @Override
    public Future<LookupEventsResult> lookupEventsAsync(final LookupEventsRequest request, final AsyncHandler<LookupEventsRequest, LookupEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<LookupEventsResult>(){

            @Override
            public LookupEventsResult call() throws Exception {
                LookupEventsResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.lookupEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LookupEventsResult> lookupEventsAsync() {
        return this.lookupEventsAsync(new LookupEventsRequest());
    }

    @Override
    public Future<LookupEventsResult> lookupEventsAsync(AsyncHandler<LookupEventsRequest, LookupEventsResult> asyncHandler) {
        return this.lookupEventsAsync(new LookupEventsRequest(), asyncHandler);
    }

    @Override
    public Future<PutEventSelectorsResult> putEventSelectorsAsync(PutEventSelectorsRequest request) {
        return this.putEventSelectorsAsync(request, null);
    }

    @Override
    public Future<PutEventSelectorsResult> putEventSelectorsAsync(final PutEventSelectorsRequest request, final AsyncHandler<PutEventSelectorsRequest, PutEventSelectorsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutEventSelectorsResult>(){

            @Override
            public PutEventSelectorsResult call() throws Exception {
                PutEventSelectorsResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.putEventSelectors(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(RemoveTagsRequest request) {
        return this.removeTagsAsync(request, null);
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(final RemoveTagsRequest request, final AsyncHandler<RemoveTagsRequest, RemoveTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsResult>(){

            @Override
            public RemoveTagsResult call() throws Exception {
                RemoveTagsResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.removeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartLoggingResult> startLoggingAsync(StartLoggingRequest request) {
        return this.startLoggingAsync(request, null);
    }

    @Override
    public Future<StartLoggingResult> startLoggingAsync(final StartLoggingRequest request, final AsyncHandler<StartLoggingRequest, StartLoggingResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartLoggingResult>(){

            @Override
            public StartLoggingResult call() throws Exception {
                StartLoggingResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.startLogging(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopLoggingResult> stopLoggingAsync(StopLoggingRequest request) {
        return this.stopLoggingAsync(request, null);
    }

    @Override
    public Future<StopLoggingResult> stopLoggingAsync(final StopLoggingRequest request, final AsyncHandler<StopLoggingRequest, StopLoggingResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopLoggingResult>(){

            @Override
            public StopLoggingResult call() throws Exception {
                StopLoggingResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.stopLogging(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTrailResult> updateTrailAsync(UpdateTrailRequest request) {
        return this.updateTrailAsync(request, null);
    }

    @Override
    public Future<UpdateTrailResult> updateTrailAsync(final UpdateTrailRequest request, final AsyncHandler<UpdateTrailRequest, UpdateTrailResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateTrailResult>(){

            @Override
            public UpdateTrailResult call() throws Exception {
                UpdateTrailResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.updateTrail(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

