/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudtrail.model.Resource;
import com.amazonaws.util.json.JSONWriter;

public class ResourceJsonMarshaller {
    private static ResourceJsonMarshaller instance;

    public void marshall(Resource resource, JSONWriter jsonWriter) {
        if (resource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (resource.getResourceType() != null) {
                jsonWriter.key("ResourceType").value((Object)resource.getResourceType());
            }
            if (resource.getResourceName() != null) {
                jsonWriter.key("ResourceName").value((Object)resource.getResourceName());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonMarshaller();
        }
        return instance;
    }
}

