/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsmv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudhsmv2.model.Cluster;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ClusterMarshaller {
    private static final MarshallingInfo<String> BACKUPPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupPolicy").build();
    private static final MarshallingInfo<StructuredPojo> BACKUPRETENTIONPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupRetentionPolicy").build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<Date> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> HSMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hsms").build();
    private static final MarshallingInfo<String> HSMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HsmType").build();
    private static final MarshallingInfo<String> PRECOPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreCoPassword").build();
    private static final MarshallingInfo<String> SECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroup").build();
    private static final MarshallingInfo<String> SOURCEBACKUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceBackupId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATEMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateMessage").build();
    private static final MarshallingInfo<Map> SUBNETMAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetMapping").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final MarshallingInfo<StructuredPojo> CERTIFICATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificates").build();
    private static final MarshallingInfo<List> TAGLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagList").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mode").build();
    private static final ClusterMarshaller instance = new ClusterMarshaller();

    public static ClusterMarshaller getInstance() {
        return instance;
    }

    public void marshall(Cluster cluster, ProtocolMarshaller protocolMarshaller) {
        if (cluster == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cluster.getBackupPolicy(), BACKUPPOLICY_BINDING);
            protocolMarshaller.marshall((Object)cluster.getBackupRetentionPolicy(), BACKUPRETENTIONPOLICY_BINDING);
            protocolMarshaller.marshall((Object)cluster.getClusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)cluster.getCreateTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall(cluster.getHsms(), HSMS_BINDING);
            protocolMarshaller.marshall((Object)cluster.getHsmType(), HSMTYPE_BINDING);
            protocolMarshaller.marshall((Object)cluster.getPreCoPassword(), PRECOPASSWORD_BINDING);
            protocolMarshaller.marshall((Object)cluster.getSecurityGroup(), SECURITYGROUP_BINDING);
            protocolMarshaller.marshall((Object)cluster.getSourceBackupId(), SOURCEBACKUPID_BINDING);
            protocolMarshaller.marshall((Object)cluster.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)cluster.getStateMessage(), STATEMESSAGE_BINDING);
            protocolMarshaller.marshall(cluster.getSubnetMapping(), SUBNETMAPPING_BINDING);
            protocolMarshaller.marshall((Object)cluster.getVpcId(), VPCID_BINDING);
            protocolMarshaller.marshall((Object)cluster.getCertificates(), CERTIFICATES_BINDING);
            protocolMarshaller.marshall(cluster.getTagList(), TAGLIST_BINDING);
            protocolMarshaller.marshall((Object)cluster.getMode(), MODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

