/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsmv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudhsmv2.model.BackupPolicy;
import com.amazonaws.services.cloudhsmv2.model.Certificates;
import com.amazonaws.services.cloudhsmv2.model.ClusterState;
import com.amazonaws.services.cloudhsmv2.model.Hsm;
import com.amazonaws.services.cloudhsmv2.model.transform.ClusterMarshaller;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cluster
implements Serializable,
Cloneable,
StructuredPojo {
    private String backupPolicy;
    private String clusterId;
    private Date createTimestamp;
    private List<Hsm> hsms;
    private String hsmType;
    private String preCoPassword;
    private String securityGroup;
    private String sourceBackupId;
    private String state;
    private String stateMessage;
    private Map<String, String> subnetMapping;
    private String vpcId;
    private Certificates certificates;

    public void setBackupPolicy(String backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    @JsonProperty(value="backupPolicy")
    public String getBackupPolicy() {
        return this.backupPolicy;
    }

    public Cluster withBackupPolicy(String backupPolicy) {
        this.setBackupPolicy(backupPolicy);
        return this;
    }

    public Cluster withBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy.toString();
        return this;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Cluster withClusterId(String clusterId) {
        this.setClusterId(clusterId);
        return this;
    }

    public void setCreateTimestamp(Date createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public Date getCreateTimestamp() {
        return this.createTimestamp;
    }

    public Cluster withCreateTimestamp(Date createTimestamp) {
        this.setCreateTimestamp(createTimestamp);
        return this;
    }

    public List<Hsm> getHsms() {
        return this.hsms;
    }

    public void setHsms(Collection<Hsm> hsms) {
        if (hsms == null) {
            this.hsms = null;
            return;
        }
        this.hsms = new ArrayList<Hsm>(hsms);
    }

    public Cluster withHsms(Hsm ... hsms) {
        if (this.hsms == null) {
            this.setHsms(new ArrayList<Hsm>(hsms.length));
        }
        for (Hsm ele : hsms) {
            this.hsms.add(ele);
        }
        return this;
    }

    public Cluster withHsms(Collection<Hsm> hsms) {
        this.setHsms(hsms);
        return this;
    }

    public void setHsmType(String hsmType) {
        this.hsmType = hsmType;
    }

    public String getHsmType() {
        return this.hsmType;
    }

    public Cluster withHsmType(String hsmType) {
        this.setHsmType(hsmType);
        return this;
    }

    public void setPreCoPassword(String preCoPassword) {
        this.preCoPassword = preCoPassword;
    }

    public String getPreCoPassword() {
        return this.preCoPassword;
    }

    public Cluster withPreCoPassword(String preCoPassword) {
        this.setPreCoPassword(preCoPassword);
        return this;
    }

    public void setSecurityGroup(String securityGroup) {
        this.securityGroup = securityGroup;
    }

    public String getSecurityGroup() {
        return this.securityGroup;
    }

    public Cluster withSecurityGroup(String securityGroup) {
        this.setSecurityGroup(securityGroup);
        return this;
    }

    public void setSourceBackupId(String sourceBackupId) {
        this.sourceBackupId = sourceBackupId;
    }

    public String getSourceBackupId() {
        return this.sourceBackupId;
    }

    public Cluster withSourceBackupId(String sourceBackupId) {
        this.setSourceBackupId(sourceBackupId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public Cluster withState(String state) {
        this.setState(state);
        return this;
    }

    public Cluster withState(ClusterState state) {
        this.state = state.toString();
        return this;
    }

    public void setStateMessage(String stateMessage) {
        this.stateMessage = stateMessage;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public Cluster withStateMessage(String stateMessage) {
        this.setStateMessage(stateMessage);
        return this;
    }

    public Map<String, String> getSubnetMapping() {
        return this.subnetMapping;
    }

    public void setSubnetMapping(Map<String, String> subnetMapping) {
        this.subnetMapping = subnetMapping;
    }

    public Cluster withSubnetMapping(Map<String, String> subnetMapping) {
        this.setSubnetMapping(subnetMapping);
        return this;
    }

    public Cluster addSubnetMappingEntry(String key, String value) {
        if (null == this.subnetMapping) {
            this.subnetMapping = new HashMap<String, String>();
        }
        if (this.subnetMapping.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.subnetMapping.put(key, value);
        return this;
    }

    public Cluster clearSubnetMappingEntries() {
        this.subnetMapping = null;
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Cluster withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setCertificates(Certificates certificates) {
        this.certificates = certificates;
    }

    public Certificates getCertificates() {
        return this.certificates;
    }

    public Cluster withCertificates(Certificates certificates) {
        this.setCertificates(certificates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBackupPolicy() != null) {
            sb.append("BackupPolicy: ").append(this.getBackupPolicy()).append(",");
        }
        if (this.getClusterId() != null) {
            sb.append("ClusterId: ").append(this.getClusterId()).append(",");
        }
        if (this.getCreateTimestamp() != null) {
            sb.append("CreateTimestamp: ").append(this.getCreateTimestamp()).append(",");
        }
        if (this.getHsms() != null) {
            sb.append("Hsms: ").append(this.getHsms()).append(",");
        }
        if (this.getHsmType() != null) {
            sb.append("HsmType: ").append(this.getHsmType()).append(",");
        }
        if (this.getPreCoPassword() != null) {
            sb.append("PreCoPassword: ").append(this.getPreCoPassword()).append(",");
        }
        if (this.getSecurityGroup() != null) {
            sb.append("SecurityGroup: ").append(this.getSecurityGroup()).append(",");
        }
        if (this.getSourceBackupId() != null) {
            sb.append("SourceBackupId: ").append(this.getSourceBackupId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateMessage() != null) {
            sb.append("StateMessage: ").append(this.getStateMessage()).append(",");
        }
        if (this.getSubnetMapping() != null) {
            sb.append("SubnetMapping: ").append(this.getSubnetMapping()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getCertificates() != null) {
            sb.append("Certificates: ").append(this.getCertificates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getBackupPolicy() == null ^ this.getBackupPolicy() == null) {
            return false;
        }
        if (other.getBackupPolicy() != null && !other.getBackupPolicy().equals(this.getBackupPolicy())) {
            return false;
        }
        if (other.getClusterId() == null ^ this.getClusterId() == null) {
            return false;
        }
        if (other.getClusterId() != null && !other.getClusterId().equals(this.getClusterId())) {
            return false;
        }
        if (other.getCreateTimestamp() == null ^ this.getCreateTimestamp() == null) {
            return false;
        }
        if (other.getCreateTimestamp() != null && !other.getCreateTimestamp().equals(this.getCreateTimestamp())) {
            return false;
        }
        if (other.getHsms() == null ^ this.getHsms() == null) {
            return false;
        }
        if (other.getHsms() != null && !other.getHsms().equals(this.getHsms())) {
            return false;
        }
        if (other.getHsmType() == null ^ this.getHsmType() == null) {
            return false;
        }
        if (other.getHsmType() != null && !other.getHsmType().equals(this.getHsmType())) {
            return false;
        }
        if (other.getPreCoPassword() == null ^ this.getPreCoPassword() == null) {
            return false;
        }
        if (other.getPreCoPassword() != null && !other.getPreCoPassword().equals(this.getPreCoPassword())) {
            return false;
        }
        if (other.getSecurityGroup() == null ^ this.getSecurityGroup() == null) {
            return false;
        }
        if (other.getSecurityGroup() != null && !other.getSecurityGroup().equals(this.getSecurityGroup())) {
            return false;
        }
        if (other.getSourceBackupId() == null ^ this.getSourceBackupId() == null) {
            return false;
        }
        if (other.getSourceBackupId() != null && !other.getSourceBackupId().equals(this.getSourceBackupId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateMessage() == null ^ this.getStateMessage() == null) {
            return false;
        }
        if (other.getStateMessage() != null && !other.getStateMessage().equals(this.getStateMessage())) {
            return false;
        }
        if (other.getSubnetMapping() == null ^ this.getSubnetMapping() == null) {
            return false;
        }
        if (other.getSubnetMapping() != null && !other.getSubnetMapping().equals(this.getSubnetMapping())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getCertificates() == null ^ this.getCertificates() == null) {
            return false;
        }
        return other.getCertificates() == null || other.getCertificates().equals(this.getCertificates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBackupPolicy() == null ? 0 : this.getBackupPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getClusterId() == null ? 0 : this.getClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTimestamp() == null ? 0 : this.getCreateTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getHsms() == null ? 0 : this.getHsms().hashCode());
        hashCode = 31 * hashCode + (this.getHsmType() == null ? 0 : this.getHsmType().hashCode());
        hashCode = 31 * hashCode + (this.getPreCoPassword() == null ? 0 : this.getPreCoPassword().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroup() == null ? 0 : this.getSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.getSourceBackupId() == null ? 0 : this.getSourceBackupId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateMessage() == null ? 0 : this.getStateMessage().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetMapping() == null ? 0 : this.getSubnetMapping().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getCertificates() == null ? 0 : this.getCertificates().hashCode());
        return hashCode;
    }

    public Cluster clone() {
        try {
            return (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

