/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudhsm.AWSCloudHSM;
import com.amazonaws.services.cloudhsm.model.CreateHapgRequest;
import com.amazonaws.services.cloudhsm.model.CreateHapgResult;
import com.amazonaws.services.cloudhsm.model.CreateHsmRequest;
import com.amazonaws.services.cloudhsm.model.CreateHsmResult;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DeleteHapgRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHapgResult;
import com.amazonaws.services.cloudhsm.model.DeleteHsmRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHsmResult;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DescribeHapgRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHapgResult;
import com.amazonaws.services.cloudhsm.model.DescribeHsmRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHsmResult;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientResult;
import com.amazonaws.services.cloudhsm.model.GetConfigRequest;
import com.amazonaws.services.cloudhsm.model.GetConfigResult;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesRequest;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesResult;
import com.amazonaws.services.cloudhsm.model.ListHapgsRequest;
import com.amazonaws.services.cloudhsm.model.ListHapgsResult;
import com.amazonaws.services.cloudhsm.model.ListHsmsRequest;
import com.amazonaws.services.cloudhsm.model.ListHsmsResult;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsRequest;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsResult;
import com.amazonaws.services.cloudhsm.model.ModifyHapgRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHapgResult;
import com.amazonaws.services.cloudhsm.model.ModifyHsmRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHsmResult;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientResult;
import com.amazonaws.services.cloudhsm.model.transform.CloudHsmInternalExceptionUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CloudHsmServiceExceptionUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHapgRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHsmRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateLunaClientRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHapgRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHsmRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteLunaClientRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHapgRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHsmRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeLunaClientRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.GetConfigRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.GetConfigResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListAvailableZonesRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListAvailableZonesResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHapgsRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHapgsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHsmsRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHsmsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListLunaClientsRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListLunaClientsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHapgRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHsmRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyLunaClientRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyLunaClientResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSCloudHSMClient
extends AmazonWebServiceClient
implements AWSCloudHSM {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudHSM.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AWSCloudHSMClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSCloudHSMClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSCloudHSMClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSCloudHSMClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AWSCloudHSMClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AWSCloudHSMClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new InvalidRequestExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new CloudHsmServiceExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new CloudHsmInternalExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("cloudhsm.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudhsm/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudhsm/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigResult getConfig(GetConfigRequest getConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetConfigRequestMarshaller().marshall(getConfigRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetConfigResultJsonUnmarshaller unmarshaller = new GetConfigResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetConfigResult getConfigResult = (GetConfigResult)response.getAwsResponse();
            return getConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHapgResult createHapg(CreateHapgRequest createHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHapgRequestMarshaller().marshall(createHapgRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateHapgResultJsonUnmarshaller unmarshaller = new CreateHapgResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateHapgResult createHapgResult = (CreateHapgResult)response.getAwsResponse();
            return createHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeHapgResult describeHapg(DescribeHapgRequest describeHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHapgRequestMarshaller().marshall(describeHapgRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeHapgResultJsonUnmarshaller unmarshaller = new DescribeHapgResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeHapgResult describeHapgResult = (DescribeHapgResult)response.getAwsResponse();
            return describeHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAvailableZonesResult listAvailableZones(ListAvailableZonesRequest listAvailableZonesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAvailableZonesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAvailableZonesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAvailableZonesRequestMarshaller().marshall(listAvailableZonesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListAvailableZonesResultJsonUnmarshaller unmarshaller = new ListAvailableZonesResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAvailableZonesResult listAvailableZonesResult = (ListAvailableZonesResult)response.getAwsResponse();
            return listAvailableZonesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyHsmResult modifyHsm(ModifyHsmRequest modifyHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyHsmRequestMarshaller().marshall(modifyHsmRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ModifyHsmResultJsonUnmarshaller unmarshaller = new ModifyHsmResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ModifyHsmResult modifyHsmResult = (ModifyHsmResult)response.getAwsResponse();
            return modifyHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLunaClientsResult listLunaClients(ListLunaClientsRequest listLunaClientsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLunaClientsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLunaClientsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLunaClientsRequestMarshaller().marshall(listLunaClientsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListLunaClientsResultJsonUnmarshaller unmarshaller = new ListLunaClientsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListLunaClientsResult listLunaClientsResult = (ListLunaClientsResult)response.getAwsResponse();
            return listLunaClientsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHapgsResult listHapgs(ListHapgsRequest listHapgsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHapgsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHapgsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHapgsRequestMarshaller().marshall(listHapgsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListHapgsResultJsonUnmarshaller unmarshaller = new ListHapgsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListHapgsResult listHapgsResult = (ListHapgsResult)response.getAwsResponse();
            return listHapgsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHsmResult deleteHsm(DeleteHsmRequest deleteHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHsmRequestMarshaller().marshall(deleteHsmRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteHsmResultJsonUnmarshaller unmarshaller = new DeleteHsmResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteHsmResult deleteHsmResult = (DeleteHsmResult)response.getAwsResponse();
            return deleteHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHsmResult createHsm(CreateHsmRequest createHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHsmRequestMarshaller().marshall(createHsmRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateHsmResultJsonUnmarshaller unmarshaller = new CreateHsmResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateHsmResult createHsmResult = (CreateHsmResult)response.getAwsResponse();
            return createHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHsmsResult listHsms(ListHsmsRequest listHsmsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHsmsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHsmsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHsmsRequestMarshaller().marshall(listHsmsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListHsmsResultJsonUnmarshaller unmarshaller = new ListHsmsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListHsmsResult listHsmsResult = (ListHsmsResult)response.getAwsResponse();
            return listHsmsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeHsmResult describeHsm(DescribeHsmRequest describeHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHsmRequestMarshaller().marshall(describeHsmRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeHsmResultJsonUnmarshaller unmarshaller = new DescribeHsmResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeHsmResult describeHsmResult = (DescribeHsmResult)response.getAwsResponse();
            return describeHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHapgResult deleteHapg(DeleteHapgRequest deleteHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHapgRequestMarshaller().marshall(deleteHapgRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteHapgResultJsonUnmarshaller unmarshaller = new DeleteHapgResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteHapgResult deleteHapgResult = (DeleteHapgResult)response.getAwsResponse();
            return deleteHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyHapgResult modifyHapg(ModifyHapgRequest modifyHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyHapgRequestMarshaller().marshall(modifyHapgRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ModifyHapgResultJsonUnmarshaller unmarshaller = new ModifyHapgResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ModifyHapgResult modifyHapgResult = (ModifyHapgResult)response.getAwsResponse();
            return modifyHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLunaClientResult createLunaClient(CreateLunaClientRequest createLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLunaClientRequestMarshaller().marshall(createLunaClientRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateLunaClientResultJsonUnmarshaller unmarshaller = new CreateLunaClientResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateLunaClientResult createLunaClientResult = (CreateLunaClientResult)response.getAwsResponse();
            return createLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLunaClientResult deleteLunaClient(DeleteLunaClientRequest deleteLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLunaClientRequestMarshaller().marshall(deleteLunaClientRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteLunaClientResultJsonUnmarshaller unmarshaller = new DeleteLunaClientResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteLunaClientResult deleteLunaClientResult = (DeleteLunaClientResult)response.getAwsResponse();
            return deleteLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyLunaClientResult modifyLunaClient(ModifyLunaClientRequest modifyLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyLunaClientRequestMarshaller().marshall(modifyLunaClientRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ModifyLunaClientResultJsonUnmarshaller unmarshaller = new ModifyLunaClientResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ModifyLunaClientResult modifyLunaClientResult = (ModifyLunaClientResult)response.getAwsResponse();
            return modifyLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLunaClientResult describeLunaClient(DescribeLunaClientRequest describeLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLunaClientRequestMarshaller().marshall(describeLunaClientRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeLunaClientResultJsonUnmarshaller unmarshaller = new DescribeLunaClientResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeLunaClientResult describeLunaClientResult = (DescribeLunaClientResult)response.getAwsResponse();
            return describeLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public ListAvailableZonesResult listAvailableZones() throws AmazonServiceException, AmazonClientException {
        return this.listAvailableZones(new ListAvailableZonesRequest());
    }

    @Override
    public ListLunaClientsResult listLunaClients() throws AmazonServiceException, AmazonClientException {
        return this.listLunaClients(new ListLunaClientsRequest());
    }

    @Override
    public ListHapgsResult listHapgs() throws AmazonServiceException, AmazonClientException {
        return this.listHapgs(new ListHapgsRequest());
    }

    @Override
    public ListHsmsResult listHsms() throws AmazonServiceException, AmazonClientException {
        return this.listHsms(new ListHsmsRequest());
    }

    @Override
    public DescribeHsmResult describeHsm() throws AmazonServiceException, AmazonClientException {
        return this.describeHsm(new DescribeHsmRequest());
    }

    @Override
    public DescribeLunaClientResult describeLunaClient() throws AmazonServiceException, AmazonClientException {
        return this.describeLunaClient(new DescribeLunaClientRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        return result;
    }
}

