/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudhsm.AWSCloudHSM;
import com.amazonaws.services.cloudhsm.AWSCloudHSMClientBuilder;
import com.amazonaws.services.cloudhsm.model.AWSCloudHSMException;
import com.amazonaws.services.cloudhsm.model.AddTagsToResourceRequest;
import com.amazonaws.services.cloudhsm.model.AddTagsToResourceResult;
import com.amazonaws.services.cloudhsm.model.CreateHapgRequest;
import com.amazonaws.services.cloudhsm.model.CreateHapgResult;
import com.amazonaws.services.cloudhsm.model.CreateHsmRequest;
import com.amazonaws.services.cloudhsm.model.CreateHsmResult;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DeleteHapgRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHapgResult;
import com.amazonaws.services.cloudhsm.model.DeleteHsmRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHsmResult;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DescribeHapgRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHapgResult;
import com.amazonaws.services.cloudhsm.model.DescribeHsmRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHsmResult;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientResult;
import com.amazonaws.services.cloudhsm.model.GetConfigRequest;
import com.amazonaws.services.cloudhsm.model.GetConfigResult;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesRequest;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesResult;
import com.amazonaws.services.cloudhsm.model.ListHapgsRequest;
import com.amazonaws.services.cloudhsm.model.ListHapgsResult;
import com.amazonaws.services.cloudhsm.model.ListHsmsRequest;
import com.amazonaws.services.cloudhsm.model.ListHsmsResult;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsRequest;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsResult;
import com.amazonaws.services.cloudhsm.model.ListTagsForResourceRequest;
import com.amazonaws.services.cloudhsm.model.ListTagsForResourceResult;
import com.amazonaws.services.cloudhsm.model.ModifyHapgRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHapgResult;
import com.amazonaws.services.cloudhsm.model.ModifyHsmRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHsmResult;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientResult;
import com.amazonaws.services.cloudhsm.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.cloudhsm.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.cloudhsm.model.transform.AddTagsToResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.AddTagsToResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CloudHsmInternalExceptionUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CloudHsmServiceExceptionUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHapgRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHsmRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateLunaClientRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHapgRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHsmRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteLunaClientRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHapgRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHsmRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeLunaClientRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.GetConfigRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.GetConfigResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListAvailableZonesRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListAvailableZonesResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHapgsRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHapgsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHsmsRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHsmsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListLunaClientsRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListLunaClientsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHapgRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHsmRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyLunaClientRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.RemoveTagsFromResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.RemoveTagsFromResourceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCloudHSMClient
extends AmazonWebServiceClient
implements AWSCloudHSM {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudHSM.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudhsm";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmInternalException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudHsmInternalExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmServiceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudHsmServiceExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCloudHSMException.class));

    @Deprecated
    public AWSCloudHSMClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSCloudHSMClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSCloudHSMClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSCloudHSMClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AWSCloudHSMClientBuilder builder() {
        return AWSCloudHSMClientBuilder.standard();
    }

    AWSCloudHSMClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCloudHSMClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://cloudhsm.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudhsm/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudhsm/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddTagsToResourceResult addTagsToResource(AddTagsToResourceRequest request) {
        request = (AddTagsToResourceRequest)this.beforeClientExecution(request);
        return this.executeAddTagsToResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddTagsToResourceResult executeAddTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsToResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsToResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsToResourceRequestProtocolMarshaller(protocolFactory).marshall((AddTagsToResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsToResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddTagsToResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsToResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsToResourceResult addTagsToResourceResult = (AddTagsToResourceResult)response.getAwsResponse();
            return addTagsToResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateHapgResult createHapg(CreateHapgRequest request) {
        request = (CreateHapgRequest)this.beforeClientExecution(request);
        return this.executeCreateHapg(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateHapgResult executeCreateHapg(CreateHapgRequest createHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHapgRequestProtocolMarshaller(protocolFactory).marshall((CreateHapgRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHapgRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateHapg");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHapgResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateHapgResult createHapgResult = (CreateHapgResult)response.getAwsResponse();
            return createHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateHsmResult createHsm(CreateHsmRequest request) {
        request = (CreateHsmRequest)this.beforeClientExecution(request);
        return this.executeCreateHsm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateHsmResult executeCreateHsm(CreateHsmRequest createHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHsmRequestProtocolMarshaller(protocolFactory).marshall((CreateHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateHsm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHsmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateHsmResult createHsmResult = (CreateHsmResult)response.getAwsResponse();
            return createHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLunaClientResult createLunaClient(CreateLunaClientRequest request) {
        request = (CreateLunaClientRequest)this.beforeClientExecution(request);
        return this.executeCreateLunaClient(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLunaClientResult executeCreateLunaClient(CreateLunaClientRequest createLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLunaClientRequestProtocolMarshaller(protocolFactory).marshall((CreateLunaClientRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLunaClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLunaClient");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLunaClientResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLunaClientResult createLunaClientResult = (CreateLunaClientResult)response.getAwsResponse();
            return createLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteHapgResult deleteHapg(DeleteHapgRequest request) {
        request = (DeleteHapgRequest)this.beforeClientExecution(request);
        return this.executeDeleteHapg(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteHapgResult executeDeleteHapg(DeleteHapgRequest deleteHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHapgRequestProtocolMarshaller(protocolFactory).marshall((DeleteHapgRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteHapgRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteHapg");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHapgResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteHapgResult deleteHapgResult = (DeleteHapgResult)response.getAwsResponse();
            return deleteHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteHsmResult deleteHsm(DeleteHsmRequest request) {
        request = (DeleteHsmRequest)this.beforeClientExecution(request);
        return this.executeDeleteHsm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteHsmResult executeDeleteHsm(DeleteHsmRequest deleteHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHsmRequestProtocolMarshaller(protocolFactory).marshall((DeleteHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteHsm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHsmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteHsmResult deleteHsmResult = (DeleteHsmResult)response.getAwsResponse();
            return deleteHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLunaClientResult deleteLunaClient(DeleteLunaClientRequest request) {
        request = (DeleteLunaClientRequest)this.beforeClientExecution(request);
        return this.executeDeleteLunaClient(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLunaClientResult executeDeleteLunaClient(DeleteLunaClientRequest deleteLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLunaClientRequestProtocolMarshaller(protocolFactory).marshall((DeleteLunaClientRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLunaClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLunaClient");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLunaClientResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLunaClientResult deleteLunaClientResult = (DeleteLunaClientResult)response.getAwsResponse();
            return deleteLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeHapgResult describeHapg(DescribeHapgRequest request) {
        request = (DescribeHapgRequest)this.beforeClientExecution(request);
        return this.executeDescribeHapg(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeHapgResult executeDescribeHapg(DescribeHapgRequest describeHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHapgRequestProtocolMarshaller(protocolFactory).marshall((DescribeHapgRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeHapgRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeHapg");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHapgResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeHapgResult describeHapgResult = (DescribeHapgResult)response.getAwsResponse();
            return describeHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeHsmResult describeHsm(DescribeHsmRequest request) {
        request = (DescribeHsmRequest)this.beforeClientExecution(request);
        return this.executeDescribeHsm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeHsmResult executeDescribeHsm(DescribeHsmRequest describeHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHsmRequestProtocolMarshaller(protocolFactory).marshall((DescribeHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeHsm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHsmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeHsmResult describeHsmResult = (DescribeHsmResult)response.getAwsResponse();
            return describeHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeHsmResult describeHsm() {
        return this.describeHsm(new DescribeHsmRequest());
    }

    @Override
    public DescribeLunaClientResult describeLunaClient(DescribeLunaClientRequest request) {
        request = (DescribeLunaClientRequest)this.beforeClientExecution(request);
        return this.executeDescribeLunaClient(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLunaClientResult executeDescribeLunaClient(DescribeLunaClientRequest describeLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLunaClientRequestProtocolMarshaller(protocolFactory).marshall((DescribeLunaClientRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLunaClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLunaClient");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLunaClientResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLunaClientResult describeLunaClientResult = (DescribeLunaClientResult)response.getAwsResponse();
            return describeLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLunaClientResult describeLunaClient() {
        return this.describeLunaClient(new DescribeLunaClientRequest());
    }

    @Override
    public GetConfigResult getConfig(GetConfigRequest request) {
        request = (GetConfigRequest)this.beforeClientExecution(request);
        return this.executeGetConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetConfigResult executeGetConfig(GetConfigRequest getConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetConfigRequestProtocolMarshaller(protocolFactory).marshall((GetConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)getConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetConfigResult getConfigResult = (GetConfigResult)response.getAwsResponse();
            return getConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAvailableZonesResult listAvailableZones(ListAvailableZonesRequest request) {
        request = (ListAvailableZonesRequest)this.beforeClientExecution(request);
        return this.executeListAvailableZones(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAvailableZonesResult executeListAvailableZones(ListAvailableZonesRequest listAvailableZonesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAvailableZonesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAvailableZonesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAvailableZonesRequestProtocolMarshaller(protocolFactory).marshall((ListAvailableZonesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAvailableZonesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAvailableZones");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAvailableZonesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAvailableZonesResult listAvailableZonesResult = (ListAvailableZonesResult)response.getAwsResponse();
            return listAvailableZonesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAvailableZonesResult listAvailableZones() {
        return this.listAvailableZones(new ListAvailableZonesRequest());
    }

    @Override
    public ListHapgsResult listHapgs(ListHapgsRequest request) {
        request = (ListHapgsRequest)this.beforeClientExecution(request);
        return this.executeListHapgs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListHapgsResult executeListHapgs(ListHapgsRequest listHapgsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHapgsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHapgsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHapgsRequestProtocolMarshaller(protocolFactory).marshall((ListHapgsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHapgsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListHapgs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHapgsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListHapgsResult listHapgsResult = (ListHapgsResult)response.getAwsResponse();
            return listHapgsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHapgsResult listHapgs() {
        return this.listHapgs(new ListHapgsRequest());
    }

    @Override
    public ListHsmsResult listHsms(ListHsmsRequest request) {
        request = (ListHsmsRequest)this.beforeClientExecution(request);
        return this.executeListHsms(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListHsmsResult executeListHsms(ListHsmsRequest listHsmsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHsmsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHsmsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHsmsRequestProtocolMarshaller(protocolFactory).marshall((ListHsmsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHsmsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListHsms");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHsmsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListHsmsResult listHsmsResult = (ListHsmsResult)response.getAwsResponse();
            return listHsmsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHsmsResult listHsms() {
        return this.listHsms(new ListHsmsRequest());
    }

    @Override
    public ListLunaClientsResult listLunaClients(ListLunaClientsRequest request) {
        request = (ListLunaClientsRequest)this.beforeClientExecution(request);
        return this.executeListLunaClients(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLunaClientsResult executeListLunaClients(ListLunaClientsRequest listLunaClientsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLunaClientsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLunaClientsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLunaClientsRequestProtocolMarshaller(protocolFactory).marshall((ListLunaClientsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLunaClientsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLunaClients");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLunaClientsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLunaClientsResult listLunaClientsResult = (ListLunaClientsResult)response.getAwsResponse();
            return listLunaClientsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLunaClientsResult listLunaClients() {
        return this.listLunaClients(new ListLunaClientsRequest());
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ModifyHapgResult modifyHapg(ModifyHapgRequest request) {
        request = (ModifyHapgRequest)this.beforeClientExecution(request);
        return this.executeModifyHapg(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ModifyHapgResult executeModifyHapg(ModifyHapgRequest modifyHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyHapgRequestProtocolMarshaller(protocolFactory).marshall((ModifyHapgRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyHapgRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ModifyHapg");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyHapgResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ModifyHapgResult modifyHapgResult = (ModifyHapgResult)response.getAwsResponse();
            return modifyHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ModifyHsmResult modifyHsm(ModifyHsmRequest request) {
        request = (ModifyHsmRequest)this.beforeClientExecution(request);
        return this.executeModifyHsm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ModifyHsmResult executeModifyHsm(ModifyHsmRequest modifyHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyHsmRequestProtocolMarshaller(protocolFactory).marshall((ModifyHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ModifyHsm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyHsmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ModifyHsmResult modifyHsmResult = (ModifyHsmResult)response.getAwsResponse();
            return modifyHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ModifyLunaClientResult modifyLunaClient(ModifyLunaClientRequest request) {
        request = (ModifyLunaClientRequest)this.beforeClientExecution(request);
        return this.executeModifyLunaClient(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ModifyLunaClientResult executeModifyLunaClient(ModifyLunaClientRequest modifyLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyLunaClientRequestProtocolMarshaller(protocolFactory).marshall((ModifyLunaClientRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyLunaClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ModifyLunaClient");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyLunaClientResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ModifyLunaClientResult modifyLunaClientResult = (ModifyLunaClientResult)response.getAwsResponse();
            return modifyLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveTagsFromResourceResult removeTagsFromResource(RemoveTagsFromResourceRequest request) {
        request = (RemoveTagsFromResourceRequest)this.beforeClientExecution(request);
        return this.executeRemoveTagsFromResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveTagsFromResourceResult executeRemoveTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsFromResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsFromResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsFromResourceRequestProtocolMarshaller(protocolFactory).marshall((RemoveTagsFromResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTagsFromResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemoveTagsFromResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsFromResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTagsFromResourceResult removeTagsFromResourceResult = (RemoveTagsFromResourceResult)response.getAwsResponse();
            return removeTagsFromResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

