/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudhsm.model.ModifyHapgRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ModifyHapgRequestMarshaller
implements Marshaller<Request<ModifyHapgRequest>, ModifyHapgRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ModifyHapgRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ModifyHapgRequest> marshall(ModifyHapgRequest modifyHapgRequest) {
        if (modifyHapgRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyHapgRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.ModifyHapg");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList partitionSerialListList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (modifyHapgRequest.getHapgArn() != null) {
                jsonGenerator.writeFieldName("HapgArn").writeValue(modifyHapgRequest.getHapgArn());
            }
            if (modifyHapgRequest.getLabel() != null) {
                jsonGenerator.writeFieldName("Label").writeValue(modifyHapgRequest.getLabel());
            }
            if (!(partitionSerialListList = (SdkInternalList)modifyHapgRequest.getPartitionSerialList()).isEmpty() || !partitionSerialListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("PartitionSerialList");
                jsonGenerator.writeStartArray();
                for (String partitionSerialListListValue : partitionSerialListList) {
                    if (partitionSerialListListValue == null) continue;
                    jsonGenerator.writeValue(partitionSerialListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

