/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudhsm.model.CreateHsmRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateHsmRequestMarshaller
implements Marshaller<Request<CreateHsmRequest>, CreateHsmRequest> {
    public Request<CreateHsmRequest> marshall(CreateHsmRequest createHsmRequest) {
        if (createHsmRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHsmRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.CreateHsm");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createHsmRequest.getSubnetId() != null) {
                jsonGenerator.writeFieldName("SubnetId").writeValue(createHsmRequest.getSubnetId());
            }
            if (createHsmRequest.getSshKey() != null) {
                jsonGenerator.writeFieldName("SshKey").writeValue(createHsmRequest.getSshKey());
            }
            if (createHsmRequest.getEniIp() != null) {
                jsonGenerator.writeFieldName("EniIp").writeValue(createHsmRequest.getEniIp());
            }
            if (createHsmRequest.getIamRoleArn() != null) {
                jsonGenerator.writeFieldName("IamRoleArn").writeValue(createHsmRequest.getIamRoleArn());
            }
            if (createHsmRequest.getExternalId() != null) {
                jsonGenerator.writeFieldName("ExternalId").writeValue(createHsmRequest.getExternalId());
            }
            if (createHsmRequest.getSubscriptionType() != null) {
                jsonGenerator.writeFieldName("SubscriptionType").writeValue(createHsmRequest.getSubscriptionType());
            }
            if (createHsmRequest.getClientToken() != null) {
                jsonGenerator.writeFieldName("ClientToken").writeValue(createHsmRequest.getClientToken());
            }
            if (createHsmRequest.getSyslogIp() != null) {
                jsonGenerator.writeFieldName("SyslogIp").writeValue(createHsmRequest.getSyslogIp());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

