/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class KeyGroupConfig
implements Serializable,
Cloneable {
    private String name;
    private SdkInternalList<String> items;
    private String comment;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public KeyGroupConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getItems() {
        if (this.items == null) {
            this.items = new SdkInternalList();
        }
        return this.items;
    }

    public void setItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new SdkInternalList(items);
    }

    public KeyGroupConfig withItems(String ... items) {
        if (this.items == null) {
            this.setItems((Collection<String>)new SdkInternalList(items.length));
        }
        for (String ele : items) {
            this.items.add((Object)ele);
        }
        return this;
    }

    public KeyGroupConfig withItems(Collection<String> items) {
        this.setItems(items);
        return this;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public KeyGroupConfig withComment(String comment) {
        this.setComment(comment);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems()).append(",");
        }
        if (this.getComment() != null) {
            sb.append("Comment: ").append(this.getComment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyGroupConfig)) {
            return false;
        }
        KeyGroupConfig other = (KeyGroupConfig)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        return other.getComment() == null || other.getComment().equals(this.getComment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        return hashCode;
    }

    public KeyGroupConfig clone() {
        try {
            return (KeyGroupConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

