/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.StatusCodes;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class StatusCodesStaxUnmarshaller
implements Unmarshaller<StatusCodes, StaxUnmarshallerContext> {
    private static StatusCodesStaxUnmarshaller instance;

    public StatusCodes unmarshall(StaxUnmarshallerContext context) throws Exception {
        StatusCodes statusCodes = new StatusCodes();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return statusCodes;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    statusCodes.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    statusCodes.withItems(new ArrayList<Integer>());
                    continue;
                }
                if (!context.testExpression("Items/StatusCode", targetDepth)) continue;
                statusCodes.withItems(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return statusCodes;
    }

    public static StatusCodesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StatusCodesStaxUnmarshaller();
        }
        return instance;
    }
}

