/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.PublicKeySummary;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PublicKeySummaryStaxUnmarshaller
implements Unmarshaller<PublicKeySummary, StaxUnmarshallerContext> {
    private static PublicKeySummaryStaxUnmarshaller instance;

    public PublicKeySummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        PublicKeySummary publicKeySummary = new PublicKeySummary();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return publicKeySummary;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    publicKeySummary.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Name", targetDepth)) {
                    publicKeySummary.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    publicKeySummary.setCreatedTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("EncodedKey", targetDepth)) {
                    publicKeySummary.setEncodedKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Comment", targetDepth)) continue;
                publicKeySummary.setComment(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return publicKeySummary;
    }

    public static PublicKeySummaryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PublicKeySummaryStaxUnmarshaller();
        }
        return instance;
    }
}

