/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.Aliases;
import com.amazonaws.services.cloudfront.model.AllowedMethods;
import com.amazonaws.services.cloudfront.model.CacheBehavior;
import com.amazonaws.services.cloudfront.model.CacheBehaviors;
import com.amazonaws.services.cloudfront.model.CachedMethods;
import com.amazonaws.services.cloudfront.model.CookieNames;
import com.amazonaws.services.cloudfront.model.CookiePreference;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CustomErrorResponse;
import com.amazonaws.services.cloudfront.model.CustomErrorResponses;
import com.amazonaws.services.cloudfront.model.CustomOriginConfig;
import com.amazonaws.services.cloudfront.model.DefaultCacheBehavior;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.GeoRestriction;
import com.amazonaws.services.cloudfront.model.Headers;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.Origins;
import com.amazonaws.services.cloudfront.model.Restrictions;
import com.amazonaws.services.cloudfront.model.S3OriginConfig;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.ViewerCertificate;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateDistributionRequestMarshaller
implements Marshaller<Request<CreateDistributionRequest>, CreateDistributionRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<CreateDistributionRequest> marshall(CreateDistributionRequest createDistributionRequest) {
        DistributionConfig distributionConfigDistributionConfig;
        if (createDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2015-09-17/");
        if (createDistributionRequest != null && (distributionConfigDistributionConfig = createDistributionRequest.getDistributionConfig()) != null) {
            Restrictions restrictionsRestrictions;
            ViewerCertificate viewerCertificateViewerCertificate;
            LoggingConfig loggingConfigLogging;
            CustomErrorResponses customErrorResponsesCustomErrorResponses;
            CacheBehaviors cacheBehaviorsCacheBehaviors;
            DefaultCacheBehavior defaultCacheBehaviorDefaultCacheBehavior;
            Origins originsOrigins;
            Aliases aliasesAliases;
            xmlWriter.startElement("DistributionConfig");
            if (distributionConfigDistributionConfig.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(distributionConfigDistributionConfig.getCallerReference()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (aliasesAliases = distributionConfigDistributionConfig.getAliases()) != null) {
                List<String> aliasesAliasesitemsList;
                xmlWriter.startElement("Aliases");
                if (aliasesAliases.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value((Object)aliasesAliases.getQuantity()).endElement();
                }
                if (aliasesAliases != null && (aliasesAliasesitemsList = aliasesAliases.getItems()) != null && aliasesAliasesitemsList.size() > 0) {
                    int aliasesAliasesitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (String aliasesAliasesitemsListValue : aliasesAliasesitemsList) {
                        xmlWriter.startElement("CNAME");
                        xmlWriter.value(aliasesAliasesitemsListValue);
                        xmlWriter.endElement();
                        ++aliasesAliasesitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.getDefaultRootObject() != null) {
                xmlWriter.startElement("DefaultRootObject").value(distributionConfigDistributionConfig.getDefaultRootObject()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (originsOrigins = distributionConfigDistributionConfig.getOrigins()) != null) {
                List<Origin> originsOriginsitemsList;
                xmlWriter.startElement("Origins");
                if (originsOrigins.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value((Object)originsOrigins.getQuantity()).endElement();
                }
                if (originsOrigins != null && (originsOriginsitemsList = originsOrigins.getItems()) != null && originsOriginsitemsList.size() > 0) {
                    int originsOriginsitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (Origin originsOriginsitemsListValue : originsOriginsitemsList) {
                        CustomOriginConfig customOriginConfigCustomOriginConfig;
                        S3OriginConfig s3OriginConfigS3OriginConfig;
                        xmlWriter.startElement("Origin");
                        if (originsOriginsitemsListValue.getId() != null) {
                            xmlWriter.startElement("Id").value(originsOriginsitemsListValue.getId()).endElement();
                        }
                        if (originsOriginsitemsListValue.getDomainName() != null) {
                            xmlWriter.startElement("DomainName").value(originsOriginsitemsListValue.getDomainName()).endElement();
                        }
                        if (originsOriginsitemsListValue.getOriginPath() != null) {
                            xmlWriter.startElement("OriginPath").value(originsOriginsitemsListValue.getOriginPath()).endElement();
                        }
                        if (originsOriginsitemsListValue != null && (s3OriginConfigS3OriginConfig = originsOriginsitemsListValue.getS3OriginConfig()) != null) {
                            xmlWriter.startElement("S3OriginConfig");
                            if (s3OriginConfigS3OriginConfig.getOriginAccessIdentity() != null) {
                                xmlWriter.startElement("OriginAccessIdentity").value(s3OriginConfigS3OriginConfig.getOriginAccessIdentity()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (originsOriginsitemsListValue != null && (customOriginConfigCustomOriginConfig = originsOriginsitemsListValue.getCustomOriginConfig()) != null) {
                            xmlWriter.startElement("CustomOriginConfig");
                            if (customOriginConfigCustomOriginConfig.getHTTPPort() != null) {
                                xmlWriter.startElement("HTTPPort").value((Object)customOriginConfigCustomOriginConfig.getHTTPPort()).endElement();
                            }
                            if (customOriginConfigCustomOriginConfig.getHTTPSPort() != null) {
                                xmlWriter.startElement("HTTPSPort").value((Object)customOriginConfigCustomOriginConfig.getHTTPSPort()).endElement();
                            }
                            if (customOriginConfigCustomOriginConfig.getOriginProtocolPolicy() != null) {
                                xmlWriter.startElement("OriginProtocolPolicy").value(customOriginConfigCustomOriginConfig.getOriginProtocolPolicy()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                        ++originsOriginsitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (defaultCacheBehaviorDefaultCacheBehavior = distributionConfigDistributionConfig.getDefaultCacheBehavior()) != null) {
                AllowedMethods allowedMethodsAllowedMethods;
                TrustedSigners trustedSignersTrustedSigners;
                ForwardedValues forwardedValuesForwardedValues;
                xmlWriter.startElement("DefaultCacheBehavior");
                if (defaultCacheBehaviorDefaultCacheBehavior.getTargetOriginId() != null) {
                    xmlWriter.startElement("TargetOriginId").value(defaultCacheBehaviorDefaultCacheBehavior.getTargetOriginId()).endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior != null && (forwardedValuesForwardedValues = defaultCacheBehaviorDefaultCacheBehavior.getForwardedValues()) != null) {
                    Headers headersHeaders;
                    CookiePreference cookiePreferenceCookies;
                    xmlWriter.startElement("ForwardedValues");
                    if (forwardedValuesForwardedValues.isQueryString() != null) {
                        xmlWriter.startElement("QueryString").value((Object)forwardedValuesForwardedValues.isQueryString()).endElement();
                    }
                    if (forwardedValuesForwardedValues != null && (cookiePreferenceCookies = forwardedValuesForwardedValues.getCookies()) != null) {
                        CookieNames cookieNamesWhitelistedNames;
                        xmlWriter.startElement("Cookies");
                        if (cookiePreferenceCookies.getForward() != null) {
                            xmlWriter.startElement("Forward").value(cookiePreferenceCookies.getForward()).endElement();
                        }
                        if (cookiePreferenceCookies != null && (cookieNamesWhitelistedNames = cookiePreferenceCookies.getWhitelistedNames()) != null) {
                            List<String> cookieNamesWhitelistedNamesitemsList;
                            xmlWriter.startElement("WhitelistedNames");
                            if (cookieNamesWhitelistedNames.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)cookieNamesWhitelistedNames.getQuantity()).endElement();
                            }
                            if (cookieNamesWhitelistedNames != null && (cookieNamesWhitelistedNamesitemsList = cookieNamesWhitelistedNames.getItems()) != null && cookieNamesWhitelistedNamesitemsList.size() > 0) {
                                int cookieNamesWhitelistedNamesitemsListIndex = 1;
                                xmlWriter.startElement("Items");
                                for (String cookieNamesWhitelistedNamesitemsListValue : cookieNamesWhitelistedNamesitemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value(cookieNamesWhitelistedNamesitemsListValue);
                                    xmlWriter.endElement();
                                    ++cookieNamesWhitelistedNamesitemsListIndex;
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (forwardedValuesForwardedValues != null && (headersHeaders = forwardedValuesForwardedValues.getHeaders()) != null) {
                        List<String> headersHeadersitemsList;
                        xmlWriter.startElement("Headers");
                        if (headersHeaders.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)headersHeaders.getQuantity()).endElement();
                        }
                        if (headersHeaders != null && (headersHeadersitemsList = headersHeaders.getItems()) != null && headersHeadersitemsList.size() > 0) {
                            int headersHeadersitemsListIndex = 1;
                            xmlWriter.startElement("Items");
                            for (String headersHeadersitemsListValue : headersHeadersitemsList) {
                                xmlWriter.startElement("Name");
                                xmlWriter.value(headersHeadersitemsListValue);
                                xmlWriter.endElement();
                                ++headersHeadersitemsListIndex;
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior != null && (trustedSignersTrustedSigners = defaultCacheBehaviorDefaultCacheBehavior.getTrustedSigners()) != null) {
                    List<String> trustedSignersTrustedSignersitemsList;
                    xmlWriter.startElement("TrustedSigners");
                    if (trustedSignersTrustedSigners.isEnabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)trustedSignersTrustedSigners.isEnabled()).endElement();
                    }
                    if (trustedSignersTrustedSigners.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)trustedSignersTrustedSigners.getQuantity()).endElement();
                    }
                    if (trustedSignersTrustedSigners != null && (trustedSignersTrustedSignersitemsList = trustedSignersTrustedSigners.getItems()) != null && trustedSignersTrustedSignersitemsList.size() > 0) {
                        int trustedSignersTrustedSignersitemsListIndex = 1;
                        xmlWriter.startElement("Items");
                        for (String trustedSignersTrustedSignersitemsListValue : trustedSignersTrustedSignersitemsList) {
                            xmlWriter.startElement("AwsAccountNumber");
                            xmlWriter.value(trustedSignersTrustedSignersitemsListValue);
                            xmlWriter.endElement();
                            ++trustedSignersTrustedSignersitemsListIndex;
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior.getViewerProtocolPolicy() != null) {
                    xmlWriter.startElement("ViewerProtocolPolicy").value(defaultCacheBehaviorDefaultCacheBehavior.getViewerProtocolPolicy()).endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior.getMinTTL() != null) {
                    xmlWriter.startElement("MinTTL").value((Object)defaultCacheBehaviorDefaultCacheBehavior.getMinTTL()).endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior != null && (allowedMethodsAllowedMethods = defaultCacheBehaviorDefaultCacheBehavior.getAllowedMethods()) != null) {
                    CachedMethods cachedMethodsCachedMethods;
                    List<String> allowedMethodsAllowedMethodsitemsList;
                    xmlWriter.startElement("AllowedMethods");
                    if (allowedMethodsAllowedMethods.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)allowedMethodsAllowedMethods.getQuantity()).endElement();
                    }
                    if (allowedMethodsAllowedMethods != null && (allowedMethodsAllowedMethodsitemsList = allowedMethodsAllowedMethods.getItems()) != null && allowedMethodsAllowedMethodsitemsList.size() > 0) {
                        int allowedMethodsAllowedMethodsitemsListIndex = 1;
                        xmlWriter.startElement("Items");
                        for (String allowedMethodsAllowedMethodsitemsListValue : allowedMethodsAllowedMethodsitemsList) {
                            xmlWriter.startElement("Method");
                            xmlWriter.value(allowedMethodsAllowedMethodsitemsListValue);
                            xmlWriter.endElement();
                            ++allowedMethodsAllowedMethodsitemsListIndex;
                        }
                        xmlWriter.endElement();
                    }
                    if (allowedMethodsAllowedMethods != null && (cachedMethodsCachedMethods = allowedMethodsAllowedMethods.getCachedMethods()) != null) {
                        List<String> cachedMethodsCachedMethodsitemsList;
                        xmlWriter.startElement("CachedMethods");
                        if (cachedMethodsCachedMethods.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)cachedMethodsCachedMethods.getQuantity()).endElement();
                        }
                        if (cachedMethodsCachedMethods != null && (cachedMethodsCachedMethodsitemsList = cachedMethodsCachedMethods.getItems()) != null && cachedMethodsCachedMethodsitemsList.size() > 0) {
                            int cachedMethodsCachedMethodsitemsListIndex = 1;
                            xmlWriter.startElement("Items");
                            for (String cachedMethodsCachedMethodsitemsListValue : cachedMethodsCachedMethodsitemsList) {
                                xmlWriter.startElement("Method");
                                xmlWriter.value(cachedMethodsCachedMethodsitemsListValue);
                                xmlWriter.endElement();
                                ++cachedMethodsCachedMethodsitemsListIndex;
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior.isSmoothStreaming() != null) {
                    xmlWriter.startElement("SmoothStreaming").value((Object)defaultCacheBehaviorDefaultCacheBehavior.isSmoothStreaming()).endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior.getDefaultTTL() != null) {
                    xmlWriter.startElement("DefaultTTL").value((Object)defaultCacheBehaviorDefaultCacheBehavior.getDefaultTTL()).endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior.getMaxTTL() != null) {
                    xmlWriter.startElement("MaxTTL").value((Object)defaultCacheBehaviorDefaultCacheBehavior.getMaxTTL()).endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior.isCompress() != null) {
                    xmlWriter.startElement("Compress").value((Object)defaultCacheBehaviorDefaultCacheBehavior.isCompress()).endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (cacheBehaviorsCacheBehaviors = distributionConfigDistributionConfig.getCacheBehaviors()) != null) {
                List<CacheBehavior> cacheBehaviorsCacheBehaviorsitemsList;
                xmlWriter.startElement("CacheBehaviors");
                if (cacheBehaviorsCacheBehaviors.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value((Object)cacheBehaviorsCacheBehaviors.getQuantity()).endElement();
                }
                if (cacheBehaviorsCacheBehaviors != null && (cacheBehaviorsCacheBehaviorsitemsList = cacheBehaviorsCacheBehaviors.getItems()) != null && cacheBehaviorsCacheBehaviorsitemsList.size() > 0) {
                    int cacheBehaviorsCacheBehaviorsitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (CacheBehavior cacheBehaviorsCacheBehaviorsitemsListValue : cacheBehaviorsCacheBehaviorsitemsList) {
                        AllowedMethods allowedMethodsAllowedMethods;
                        TrustedSigners trustedSignersTrustedSigners;
                        ForwardedValues forwardedValuesForwardedValues;
                        xmlWriter.startElement("CacheBehavior");
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getPathPattern() != null) {
                            xmlWriter.startElement("PathPattern").value(cacheBehaviorsCacheBehaviorsitemsListValue.getPathPattern()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getTargetOriginId() != null) {
                            xmlWriter.startElement("TargetOriginId").value(cacheBehaviorsCacheBehaviorsitemsListValue.getTargetOriginId()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue != null && (forwardedValuesForwardedValues = cacheBehaviorsCacheBehaviorsitemsListValue.getForwardedValues()) != null) {
                            Headers headersHeaders;
                            CookiePreference cookiePreferenceCookies;
                            xmlWriter.startElement("ForwardedValues");
                            if (forwardedValuesForwardedValues.isQueryString() != null) {
                                xmlWriter.startElement("QueryString").value((Object)forwardedValuesForwardedValues.isQueryString()).endElement();
                            }
                            if (forwardedValuesForwardedValues != null && (cookiePreferenceCookies = forwardedValuesForwardedValues.getCookies()) != null) {
                                CookieNames cookieNamesWhitelistedNames;
                                xmlWriter.startElement("Cookies");
                                if (cookiePreferenceCookies.getForward() != null) {
                                    xmlWriter.startElement("Forward").value(cookiePreferenceCookies.getForward()).endElement();
                                }
                                if (cookiePreferenceCookies != null && (cookieNamesWhitelistedNames = cookiePreferenceCookies.getWhitelistedNames()) != null) {
                                    List<String> cookieNamesWhitelistedNamesitemsList;
                                    xmlWriter.startElement("WhitelistedNames");
                                    if (cookieNamesWhitelistedNames.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)cookieNamesWhitelistedNames.getQuantity()).endElement();
                                    }
                                    if (cookieNamesWhitelistedNames != null && (cookieNamesWhitelistedNamesitemsList = cookieNamesWhitelistedNames.getItems()) != null && cookieNamesWhitelistedNamesitemsList.size() > 0) {
                                        int cookieNamesWhitelistedNamesitemsListIndex = 1;
                                        xmlWriter.startElement("Items");
                                        for (String cookieNamesWhitelistedNamesitemsListValue : cookieNamesWhitelistedNamesitemsList) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(cookieNamesWhitelistedNamesitemsListValue);
                                            xmlWriter.endElement();
                                            ++cookieNamesWhitelistedNamesitemsListIndex;
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (forwardedValuesForwardedValues != null && (headersHeaders = forwardedValuesForwardedValues.getHeaders()) != null) {
                                List<String> headersHeadersitemsList;
                                xmlWriter.startElement("Headers");
                                if (headersHeaders.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)headersHeaders.getQuantity()).endElement();
                                }
                                if (headersHeaders != null && (headersHeadersitemsList = headersHeaders.getItems()) != null && headersHeadersitemsList.size() > 0) {
                                    int headersHeadersitemsListIndex = 1;
                                    xmlWriter.startElement("Items");
                                    for (String headersHeadersitemsListValue : headersHeadersitemsList) {
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value(headersHeadersitemsListValue);
                                        xmlWriter.endElement();
                                        ++headersHeadersitemsListIndex;
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue != null && (trustedSignersTrustedSigners = cacheBehaviorsCacheBehaviorsitemsListValue.getTrustedSigners()) != null) {
                            List<String> trustedSignersTrustedSignersitemsList;
                            xmlWriter.startElement("TrustedSigners");
                            if (trustedSignersTrustedSigners.isEnabled() != null) {
                                xmlWriter.startElement("Enabled").value((Object)trustedSignersTrustedSigners.isEnabled()).endElement();
                            }
                            if (trustedSignersTrustedSigners.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)trustedSignersTrustedSigners.getQuantity()).endElement();
                            }
                            if (trustedSignersTrustedSigners != null && (trustedSignersTrustedSignersitemsList = trustedSignersTrustedSigners.getItems()) != null && trustedSignersTrustedSignersitemsList.size() > 0) {
                                int trustedSignersTrustedSignersitemsListIndex = 1;
                                xmlWriter.startElement("Items");
                                for (String trustedSignersTrustedSignersitemsListValue : trustedSignersTrustedSignersitemsList) {
                                    xmlWriter.startElement("AwsAccountNumber");
                                    xmlWriter.value(trustedSignersTrustedSignersitemsListValue);
                                    xmlWriter.endElement();
                                    ++trustedSignersTrustedSignersitemsListIndex;
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getViewerProtocolPolicy() != null) {
                            xmlWriter.startElement("ViewerProtocolPolicy").value(cacheBehaviorsCacheBehaviorsitemsListValue.getViewerProtocolPolicy()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getMinTTL() != null) {
                            xmlWriter.startElement("MinTTL").value((Object)cacheBehaviorsCacheBehaviorsitemsListValue.getMinTTL()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue != null && (allowedMethodsAllowedMethods = cacheBehaviorsCacheBehaviorsitemsListValue.getAllowedMethods()) != null) {
                            CachedMethods cachedMethodsCachedMethods;
                            List<String> allowedMethodsAllowedMethodsitemsList;
                            xmlWriter.startElement("AllowedMethods");
                            if (allowedMethodsAllowedMethods.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)allowedMethodsAllowedMethods.getQuantity()).endElement();
                            }
                            if (allowedMethodsAllowedMethods != null && (allowedMethodsAllowedMethodsitemsList = allowedMethodsAllowedMethods.getItems()) != null && allowedMethodsAllowedMethodsitemsList.size() > 0) {
                                int allowedMethodsAllowedMethodsitemsListIndex = 1;
                                xmlWriter.startElement("Items");
                                for (String allowedMethodsAllowedMethodsitemsListValue : allowedMethodsAllowedMethodsitemsList) {
                                    xmlWriter.startElement("Method");
                                    xmlWriter.value(allowedMethodsAllowedMethodsitemsListValue);
                                    xmlWriter.endElement();
                                    ++allowedMethodsAllowedMethodsitemsListIndex;
                                }
                                xmlWriter.endElement();
                            }
                            if (allowedMethodsAllowedMethods != null && (cachedMethodsCachedMethods = allowedMethodsAllowedMethods.getCachedMethods()) != null) {
                                List<String> cachedMethodsCachedMethodsitemsList;
                                xmlWriter.startElement("CachedMethods");
                                if (cachedMethodsCachedMethods.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)cachedMethodsCachedMethods.getQuantity()).endElement();
                                }
                                if (cachedMethodsCachedMethods != null && (cachedMethodsCachedMethodsitemsList = cachedMethodsCachedMethods.getItems()) != null && cachedMethodsCachedMethodsitemsList.size() > 0) {
                                    int cachedMethodsCachedMethodsitemsListIndex = 1;
                                    xmlWriter.startElement("Items");
                                    for (String cachedMethodsCachedMethodsitemsListValue : cachedMethodsCachedMethodsitemsList) {
                                        xmlWriter.startElement("Method");
                                        xmlWriter.value(cachedMethodsCachedMethodsitemsListValue);
                                        xmlWriter.endElement();
                                        ++cachedMethodsCachedMethodsitemsListIndex;
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.isSmoothStreaming() != null) {
                            xmlWriter.startElement("SmoothStreaming").value((Object)cacheBehaviorsCacheBehaviorsitemsListValue.isSmoothStreaming()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getDefaultTTL() != null) {
                            xmlWriter.startElement("DefaultTTL").value((Object)cacheBehaviorsCacheBehaviorsitemsListValue.getDefaultTTL()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getMaxTTL() != null) {
                            xmlWriter.startElement("MaxTTL").value((Object)cacheBehaviorsCacheBehaviorsitemsListValue.getMaxTTL()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.isCompress() != null) {
                            xmlWriter.startElement("Compress").value((Object)cacheBehaviorsCacheBehaviorsitemsListValue.isCompress()).endElement();
                        }
                        xmlWriter.endElement();
                        ++cacheBehaviorsCacheBehaviorsitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (customErrorResponsesCustomErrorResponses = distributionConfigDistributionConfig.getCustomErrorResponses()) != null) {
                List<CustomErrorResponse> customErrorResponsesCustomErrorResponsesitemsList;
                xmlWriter.startElement("CustomErrorResponses");
                if (customErrorResponsesCustomErrorResponses.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value((Object)customErrorResponsesCustomErrorResponses.getQuantity()).endElement();
                }
                if (customErrorResponsesCustomErrorResponses != null && (customErrorResponsesCustomErrorResponsesitemsList = customErrorResponsesCustomErrorResponses.getItems()) != null && customErrorResponsesCustomErrorResponsesitemsList.size() > 0) {
                    int customErrorResponsesCustomErrorResponsesitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (CustomErrorResponse customErrorResponsesCustomErrorResponsesitemsListValue : customErrorResponsesCustomErrorResponsesitemsList) {
                        xmlWriter.startElement("CustomErrorResponse");
                        if (customErrorResponsesCustomErrorResponsesitemsListValue.getErrorCode() != null) {
                            xmlWriter.startElement("ErrorCode").value((Object)customErrorResponsesCustomErrorResponsesitemsListValue.getErrorCode()).endElement();
                        }
                        if (customErrorResponsesCustomErrorResponsesitemsListValue.getResponsePagePath() != null) {
                            xmlWriter.startElement("ResponsePagePath").value(customErrorResponsesCustomErrorResponsesitemsListValue.getResponsePagePath()).endElement();
                        }
                        if (customErrorResponsesCustomErrorResponsesitemsListValue.getResponseCode() != null) {
                            xmlWriter.startElement("ResponseCode").value(customErrorResponsesCustomErrorResponsesitemsListValue.getResponseCode()).endElement();
                        }
                        if (customErrorResponsesCustomErrorResponsesitemsListValue.getErrorCachingMinTTL() != null) {
                            xmlWriter.startElement("ErrorCachingMinTTL").value((Object)customErrorResponsesCustomErrorResponsesitemsListValue.getErrorCachingMinTTL()).endElement();
                        }
                        xmlWriter.endElement();
                        ++customErrorResponsesCustomErrorResponsesitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.getComment() != null) {
                xmlWriter.startElement("Comment").value(distributionConfigDistributionConfig.getComment()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (loggingConfigLogging = distributionConfigDistributionConfig.getLogging()) != null) {
                xmlWriter.startElement("Logging");
                if (loggingConfigLogging.isEnabled() != null) {
                    xmlWriter.startElement("Enabled").value((Object)loggingConfigLogging.isEnabled()).endElement();
                }
                if (loggingConfigLogging.isIncludeCookies() != null) {
                    xmlWriter.startElement("IncludeCookies").value((Object)loggingConfigLogging.isIncludeCookies()).endElement();
                }
                if (loggingConfigLogging.getBucket() != null) {
                    xmlWriter.startElement("Bucket").value(loggingConfigLogging.getBucket()).endElement();
                }
                if (loggingConfigLogging.getPrefix() != null) {
                    xmlWriter.startElement("Prefix").value(loggingConfigLogging.getPrefix()).endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.getPriceClass() != null) {
                xmlWriter.startElement("PriceClass").value(distributionConfigDistributionConfig.getPriceClass()).endElement();
            }
            if (distributionConfigDistributionConfig.isEnabled() != null) {
                xmlWriter.startElement("Enabled").value((Object)distributionConfigDistributionConfig.isEnabled()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (viewerCertificateViewerCertificate = distributionConfigDistributionConfig.getViewerCertificate()) != null) {
                xmlWriter.startElement("ViewerCertificate");
                if (viewerCertificateViewerCertificate.getCertificate() != null) {
                    xmlWriter.startElement("Certificate").value(viewerCertificateViewerCertificate.getCertificate()).endElement();
                }
                if (viewerCertificateViewerCertificate.getCertificateSource() != null) {
                    xmlWriter.startElement("CertificateSource").value(viewerCertificateViewerCertificate.getCertificateSource()).endElement();
                }
                if (viewerCertificateViewerCertificate.getSSLSupportMethod() != null) {
                    xmlWriter.startElement("SSLSupportMethod").value(viewerCertificateViewerCertificate.getSSLSupportMethod()).endElement();
                }
                if (viewerCertificateViewerCertificate.getMinimumProtocolVersion() != null) {
                    xmlWriter.startElement("MinimumProtocolVersion").value(viewerCertificateViewerCertificate.getMinimumProtocolVersion()).endElement();
                }
                if (viewerCertificateViewerCertificate.getIAMCertificateId() != null) {
                    xmlWriter.startElement("IAMCertificateId").value(viewerCertificateViewerCertificate.getIAMCertificateId()).endElement();
                }
                if (viewerCertificateViewerCertificate.isCloudFrontDefaultCertificate() != null) {
                    xmlWriter.startElement("CloudFrontDefaultCertificate").value((Object)viewerCertificateViewerCertificate.isCloudFrontDefaultCertificate()).endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (restrictionsRestrictions = distributionConfigDistributionConfig.getRestrictions()) != null) {
                GeoRestriction geoRestrictionGeoRestriction;
                xmlWriter.startElement("Restrictions");
                if (restrictionsRestrictions != null && (geoRestrictionGeoRestriction = restrictionsRestrictions.getGeoRestriction()) != null) {
                    List<String> geoRestrictionGeoRestrictionitemsList;
                    xmlWriter.startElement("GeoRestriction");
                    if (geoRestrictionGeoRestriction.getRestrictionType() != null) {
                        xmlWriter.startElement("RestrictionType").value(geoRestrictionGeoRestriction.getRestrictionType()).endElement();
                    }
                    if (geoRestrictionGeoRestriction.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)geoRestrictionGeoRestriction.getQuantity()).endElement();
                    }
                    if (geoRestrictionGeoRestriction != null && (geoRestrictionGeoRestrictionitemsList = geoRestrictionGeoRestriction.getItems()) != null && geoRestrictionGeoRestrictionitemsList.size() > 0) {
                        int geoRestrictionGeoRestrictionitemsListIndex = 1;
                        xmlWriter.startElement("Items");
                        for (String geoRestrictionGeoRestrictionitemsListValue : geoRestrictionGeoRestrictionitemsList) {
                            xmlWriter.startElement("Location");
                            xmlWriter.value(geoRestrictionGeoRestrictionitemsListValue);
                            xmlWriter.endElement();
                            ++geoRestrictionGeoRestrictionitemsListIndex;
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.getWebACLId() != null) {
                xmlWriter.startElement("WebACLId").value(distributionConfigDistributionConfig.getWebACLId()).endElement();
            }
            xmlWriter.endElement();
        }
        try {
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", (Throwable)e);
        }
        return request;
    }

    static {
        String path = "2015-09-17/distribution";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

