/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.TemplateProgress;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class TemplateProgressStaxUnmarshaller
implements Unmarshaller<TemplateProgress, StaxUnmarshallerContext> {
    private static TemplateProgressStaxUnmarshaller instance;

    public TemplateProgress unmarshall(StaxUnmarshallerContext context) throws Exception {
        TemplateProgress templateProgress = new TemplateProgress();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return templateProgress;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourcesSucceeded", targetDepth)) {
                    templateProgress.setResourcesSucceeded(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourcesFailed", targetDepth)) {
                    templateProgress.setResourcesFailed(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourcesProcessing", targetDepth)) {
                    templateProgress.setResourcesProcessing(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourcesPending", targetDepth)) continue;
                templateProgress.setResourcesPending(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return templateProgress;
    }

    public static TemplateProgressStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TemplateProgressStaxUnmarshaller();
        }
        return instance;
    }
}

