/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ExecuteChangeSetRequestMarshaller
implements Marshaller<Request<ExecuteChangeSetRequest>, ExecuteChangeSetRequest> {
    public Request<ExecuteChangeSetRequest> marshall(ExecuteChangeSetRequest executeChangeSetRequest) {
        if (executeChangeSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)executeChangeSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ExecuteChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (executeChangeSetRequest.getChangeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)executeChangeSetRequest.getChangeSetName()));
        }
        if (executeChangeSetRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)executeChangeSetRequest.getStackName()));
        }
        return request;
    }
}

