/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.BatchWriteOperation;
import com.amazonaws.services.clouddirectory.model.transform.BatchAddFacetToObjectJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.BatchAttachObjectJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.BatchCreateObjectJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.BatchDeleteObjectJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.BatchDetachObjectJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.BatchRemoveFacetFromObjectJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.BatchUpdateObjectAttributesJsonMarshaller;

public class BatchWriteOperationJsonMarshaller {
    private static BatchWriteOperationJsonMarshaller instance;

    public void marshall(BatchWriteOperation batchWriteOperation, StructuredJsonGenerator jsonGenerator) {
        if (batchWriteOperation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (batchWriteOperation.getCreateObject() != null) {
                jsonGenerator.writeFieldName("CreateObject");
                BatchCreateObjectJsonMarshaller.getInstance().marshall(batchWriteOperation.getCreateObject(), jsonGenerator);
            }
            if (batchWriteOperation.getAttachObject() != null) {
                jsonGenerator.writeFieldName("AttachObject");
                BatchAttachObjectJsonMarshaller.getInstance().marshall(batchWriteOperation.getAttachObject(), jsonGenerator);
            }
            if (batchWriteOperation.getDetachObject() != null) {
                jsonGenerator.writeFieldName("DetachObject");
                BatchDetachObjectJsonMarshaller.getInstance().marshall(batchWriteOperation.getDetachObject(), jsonGenerator);
            }
            if (batchWriteOperation.getUpdateObjectAttributes() != null) {
                jsonGenerator.writeFieldName("UpdateObjectAttributes");
                BatchUpdateObjectAttributesJsonMarshaller.getInstance().marshall(batchWriteOperation.getUpdateObjectAttributes(), jsonGenerator);
            }
            if (batchWriteOperation.getDeleteObject() != null) {
                jsonGenerator.writeFieldName("DeleteObject");
                BatchDeleteObjectJsonMarshaller.getInstance().marshall(batchWriteOperation.getDeleteObject(), jsonGenerator);
            }
            if (batchWriteOperation.getAddFacetToObject() != null) {
                jsonGenerator.writeFieldName("AddFacetToObject");
                BatchAddFacetToObjectJsonMarshaller.getInstance().marshall(batchWriteOperation.getAddFacetToObject(), jsonGenerator);
            }
            if (batchWriteOperation.getRemoveFacetFromObject() != null) {
                jsonGenerator.writeFieldName("RemoveFacetFromObject");
                BatchRemoveFacetFromObjectJsonMarshaller.getInstance().marshall(batchWriteOperation.getRemoveFacetFromObject(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BatchWriteOperationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BatchWriteOperationJsonMarshaller();
        }
        return instance;
    }
}

