/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.PublishSchemaRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PublishSchemaRequestMarshaller
implements Marshaller<Request<PublishSchemaRequest>, PublishSchemaRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PublishSchemaRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PublishSchemaRequest> marshall(PublishSchemaRequest publishSchemaRequest) {
        if (publishSchemaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishSchemaRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (publishSchemaRequest.getDevelopmentSchemaArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)publishSchemaRequest.getDevelopmentSchemaArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/schema/publish";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (publishSchemaRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(publishSchemaRequest.getVersion());
            }
            if (publishSchemaRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(publishSchemaRequest.getName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

