/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloud9;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloud9.AWSCloud9;
import com.amazonaws.services.cloud9.AWSCloud9ClientBuilder;
import com.amazonaws.services.cloud9.model.AWSCloud9Exception;
import com.amazonaws.services.cloud9.model.BadRequestException;
import com.amazonaws.services.cloud9.model.ConflictException;
import com.amazonaws.services.cloud9.model.CreateEnvironmentEC2Request;
import com.amazonaws.services.cloud9.model.CreateEnvironmentEC2Result;
import com.amazonaws.services.cloud9.model.CreateEnvironmentMembershipRequest;
import com.amazonaws.services.cloud9.model.CreateEnvironmentMembershipResult;
import com.amazonaws.services.cloud9.model.DeleteEnvironmentMembershipRequest;
import com.amazonaws.services.cloud9.model.DeleteEnvironmentMembershipResult;
import com.amazonaws.services.cloud9.model.DeleteEnvironmentRequest;
import com.amazonaws.services.cloud9.model.DeleteEnvironmentResult;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentMembershipsRequest;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentMembershipsResult;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentStatusRequest;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentStatusResult;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentsResult;
import com.amazonaws.services.cloud9.model.ForbiddenException;
import com.amazonaws.services.cloud9.model.InternalServerErrorException;
import com.amazonaws.services.cloud9.model.LimitExceededException;
import com.amazonaws.services.cloud9.model.ListEnvironmentsRequest;
import com.amazonaws.services.cloud9.model.ListEnvironmentsResult;
import com.amazonaws.services.cloud9.model.NotFoundException;
import com.amazonaws.services.cloud9.model.TooManyRequestsException;
import com.amazonaws.services.cloud9.model.UpdateEnvironmentMembershipRequest;
import com.amazonaws.services.cloud9.model.UpdateEnvironmentMembershipResult;
import com.amazonaws.services.cloud9.model.UpdateEnvironmentRequest;
import com.amazonaws.services.cloud9.model.UpdateEnvironmentResult;
import com.amazonaws.services.cloud9.model.transform.CreateEnvironmentEC2RequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.CreateEnvironmentEC2ResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.CreateEnvironmentMembershipRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.CreateEnvironmentMembershipResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.DeleteEnvironmentMembershipRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.DeleteEnvironmentMembershipResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.DeleteEnvironmentRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.DeleteEnvironmentResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.DescribeEnvironmentMembershipsRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.DescribeEnvironmentMembershipsResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.DescribeEnvironmentStatusRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.DescribeEnvironmentStatusResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.DescribeEnvironmentsRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.DescribeEnvironmentsResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.ListEnvironmentsRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.ListEnvironmentsResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.UpdateEnvironmentMembershipRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.UpdateEnvironmentMembershipResultJsonUnmarshaller;
import com.amazonaws.services.cloud9.model.transform.UpdateEnvironmentRequestProtocolMarshaller;
import com.amazonaws.services.cloud9.model.transform.UpdateEnvironmentResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCloud9Client
extends AmazonWebServiceClient
implements AWSCloud9 {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloud9.class);
    private static final String DEFAULT_SIGNING_NAME = "cloud9";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(ConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AWSCloud9Exception.class));

    public static AWSCloud9ClientBuilder builder() {
        return AWSCloud9ClientBuilder.standard();
    }

    AWSCloud9Client(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCloud9Client(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("cloud9.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloud9/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloud9/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateEnvironmentEC2Result createEnvironmentEC2(CreateEnvironmentEC2Request request) {
        request = (CreateEnvironmentEC2Request)this.beforeClientExecution(request);
        return this.executeCreateEnvironmentEC2(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEnvironmentEC2Result executeCreateEnvironmentEC2(CreateEnvironmentEC2Request createEnvironmentEC2Request) {
        ExecutionContext executionContext = this.createExecutionContext(createEnvironmentEC2Request);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEnvironmentEC2Request> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEnvironmentEC2RequestProtocolMarshaller(protocolFactory).marshall((CreateEnvironmentEC2Request)super.beforeMarshalling((AmazonWebServiceRequest)createEnvironmentEC2Request));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEnvironmentEC2");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEnvironmentEC2ResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEnvironmentEC2Result createEnvironmentEC2Result = (CreateEnvironmentEC2Result)response.getAwsResponse();
            return createEnvironmentEC2Result;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateEnvironmentMembershipResult createEnvironmentMembership(CreateEnvironmentMembershipRequest request) {
        request = (CreateEnvironmentMembershipRequest)this.beforeClientExecution(request);
        return this.executeCreateEnvironmentMembership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEnvironmentMembershipResult executeCreateEnvironmentMembership(CreateEnvironmentMembershipRequest createEnvironmentMembershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEnvironmentMembershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEnvironmentMembershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEnvironmentMembershipRequestProtocolMarshaller(protocolFactory).marshall((CreateEnvironmentMembershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEnvironmentMembershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEnvironmentMembership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEnvironmentMembershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEnvironmentMembershipResult createEnvironmentMembershipResult = (CreateEnvironmentMembershipResult)response.getAwsResponse();
            return createEnvironmentMembershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEnvironmentResult deleteEnvironment(DeleteEnvironmentRequest request) {
        request = (DeleteEnvironmentRequest)this.beforeClientExecution(request);
        return this.executeDeleteEnvironment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEnvironmentResult executeDeleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEnvironmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEnvironmentRequestProtocolMarshaller(protocolFactory).marshall((DeleteEnvironmentRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEnvironmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEnvironment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEnvironmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEnvironmentResult deleteEnvironmentResult = (DeleteEnvironmentResult)response.getAwsResponse();
            return deleteEnvironmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEnvironmentMembershipResult deleteEnvironmentMembership(DeleteEnvironmentMembershipRequest request) {
        request = (DeleteEnvironmentMembershipRequest)this.beforeClientExecution(request);
        return this.executeDeleteEnvironmentMembership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEnvironmentMembershipResult executeDeleteEnvironmentMembership(DeleteEnvironmentMembershipRequest deleteEnvironmentMembershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEnvironmentMembershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEnvironmentMembershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEnvironmentMembershipRequestProtocolMarshaller(protocolFactory).marshall((DeleteEnvironmentMembershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEnvironmentMembershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEnvironmentMembership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEnvironmentMembershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEnvironmentMembershipResult deleteEnvironmentMembershipResult = (DeleteEnvironmentMembershipResult)response.getAwsResponse();
            return deleteEnvironmentMembershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEnvironmentMembershipsResult describeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest request) {
        request = (DescribeEnvironmentMembershipsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEnvironmentMemberships(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEnvironmentMembershipsResult executeDescribeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest describeEnvironmentMembershipsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEnvironmentMembershipsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEnvironmentMembershipsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEnvironmentMembershipsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEnvironmentMembershipsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEnvironmentMembershipsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEnvironmentMemberships");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEnvironmentMembershipsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEnvironmentMembershipsResult describeEnvironmentMembershipsResult = (DescribeEnvironmentMembershipsResult)response.getAwsResponse();
            return describeEnvironmentMembershipsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEnvironmentStatusResult describeEnvironmentStatus(DescribeEnvironmentStatusRequest request) {
        request = (DescribeEnvironmentStatusRequest)this.beforeClientExecution(request);
        return this.executeDescribeEnvironmentStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEnvironmentStatusResult executeDescribeEnvironmentStatus(DescribeEnvironmentStatusRequest describeEnvironmentStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEnvironmentStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEnvironmentStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEnvironmentStatusRequestProtocolMarshaller(protocolFactory).marshall((DescribeEnvironmentStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEnvironmentStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEnvironmentStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEnvironmentStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEnvironmentStatusResult describeEnvironmentStatusResult = (DescribeEnvironmentStatusResult)response.getAwsResponse();
            return describeEnvironmentStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEnvironmentsResult describeEnvironments(DescribeEnvironmentsRequest request) {
        request = (DescribeEnvironmentsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEnvironments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEnvironmentsResult executeDescribeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEnvironmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEnvironmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEnvironmentsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEnvironmentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEnvironmentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEnvironments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEnvironmentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEnvironmentsResult describeEnvironmentsResult = (DescribeEnvironmentsResult)response.getAwsResponse();
            return describeEnvironmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEnvironmentsResult listEnvironments(ListEnvironmentsRequest request) {
        request = (ListEnvironmentsRequest)this.beforeClientExecution(request);
        return this.executeListEnvironments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEnvironmentsResult executeListEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEnvironmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEnvironmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEnvironmentsRequestProtocolMarshaller(protocolFactory).marshall((ListEnvironmentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEnvironmentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEnvironments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEnvironmentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEnvironmentsResult listEnvironmentsResult = (ListEnvironmentsResult)response.getAwsResponse();
            return listEnvironmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEnvironmentResult updateEnvironment(UpdateEnvironmentRequest request) {
        request = (UpdateEnvironmentRequest)this.beforeClientExecution(request);
        return this.executeUpdateEnvironment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEnvironmentResult executeUpdateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEnvironmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEnvironmentRequestProtocolMarshaller(protocolFactory).marshall((UpdateEnvironmentRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEnvironmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEnvironment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEnvironmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEnvironmentResult updateEnvironmentResult = (UpdateEnvironmentResult)response.getAwsResponse();
            return updateEnvironmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEnvironmentMembershipResult updateEnvironmentMembership(UpdateEnvironmentMembershipRequest request) {
        request = (UpdateEnvironmentMembershipRequest)this.beforeClientExecution(request);
        return this.executeUpdateEnvironmentMembership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEnvironmentMembershipResult executeUpdateEnvironmentMembership(UpdateEnvironmentMembershipRequest updateEnvironmentMembershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEnvironmentMembershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEnvironmentMembershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEnvironmentMembershipRequestProtocolMarshaller(protocolFactory).marshall((UpdateEnvironmentMembershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEnvironmentMembershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cloud9");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEnvironmentMembership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEnvironmentMembershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEnvironmentMembershipResult updateEnvironmentMembershipResult = (UpdateEnvironmentMembershipResult)response.getAwsResponse();
            return updateEnvironmentMembershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

