/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanrooms.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/PopulateIdMappingTable" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PopulateIdMappingTableResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The unique identifier of the mapping job that will populate the ID mapping table.
     * </p>
     */
    private String idMappingJobId;

    /**
     * <p>
     * The unique identifier of the mapping job that will populate the ID mapping table.
     * </p>
     * 
     * @param idMappingJobId
     *        The unique identifier of the mapping job that will populate the ID mapping table.
     */

    public void setIdMappingJobId(String idMappingJobId) {
        this.idMappingJobId = idMappingJobId;
    }

    /**
     * <p>
     * The unique identifier of the mapping job that will populate the ID mapping table.
     * </p>
     * 
     * @return The unique identifier of the mapping job that will populate the ID mapping table.
     */

    public String getIdMappingJobId() {
        return this.idMappingJobId;
    }

    /**
     * <p>
     * The unique identifier of the mapping job that will populate the ID mapping table.
     * </p>
     * 
     * @param idMappingJobId
     *        The unique identifier of the mapping job that will populate the ID mapping table.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PopulateIdMappingTableResult withIdMappingJobId(String idMappingJobId) {
        setIdMappingJobId(idMappingJobId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIdMappingJobId() != null)
            sb.append("IdMappingJobId: ").append(getIdMappingJobId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PopulateIdMappingTableResult == false)
            return false;
        PopulateIdMappingTableResult other = (PopulateIdMappingTableResult) obj;
        if (other.getIdMappingJobId() == null ^ this.getIdMappingJobId() == null)
            return false;
        if (other.getIdMappingJobId() != null && other.getIdMappingJobId().equals(this.getIdMappingJobId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIdMappingJobId() == null) ? 0 : getIdMappingJobId().hashCode());
        return hashCode;
    }

    @Override
    public PopulateIdMappingTableResult clone() {
        try {
            return (PopulateIdMappingTableResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
