/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanrooms;

import javax.annotation.Generated;

import com.amazonaws.services.cleanrooms.model.*;

/**
 * Abstract implementation of {@code AWSCleanRoomsAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSCleanRoomsAsync extends AbstractAWSCleanRooms implements AWSCleanRoomsAsync {

    protected AbstractAWSCleanRoomsAsync() {
    }

    @Override
    public java.util.concurrent.Future<BatchGetSchemaResult> batchGetSchemaAsync(BatchGetSchemaRequest request) {

        return batchGetSchemaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchGetSchemaResult> batchGetSchemaAsync(BatchGetSchemaRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchGetSchemaRequest, BatchGetSchemaResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateCollaborationResult> createCollaborationAsync(CreateCollaborationRequest request) {

        return createCollaborationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateCollaborationResult> createCollaborationAsync(CreateCollaborationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateCollaborationRequest, CreateCollaborationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateConfiguredTableResult> createConfiguredTableAsync(CreateConfiguredTableRequest request) {

        return createConfiguredTableAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateConfiguredTableResult> createConfiguredTableAsync(CreateConfiguredTableRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateConfiguredTableRequest, CreateConfiguredTableResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateConfiguredTableAnalysisRuleResult> createConfiguredTableAnalysisRuleAsync(
            CreateConfiguredTableAnalysisRuleRequest request) {

        return createConfiguredTableAnalysisRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateConfiguredTableAnalysisRuleResult> createConfiguredTableAnalysisRuleAsync(
            CreateConfiguredTableAnalysisRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateConfiguredTableAnalysisRuleRequest, CreateConfiguredTableAnalysisRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateConfiguredTableAssociationResult> createConfiguredTableAssociationAsync(
            CreateConfiguredTableAssociationRequest request) {

        return createConfiguredTableAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateConfiguredTableAssociationResult> createConfiguredTableAssociationAsync(
            CreateConfiguredTableAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateConfiguredTableAssociationRequest, CreateConfiguredTableAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateMembershipResult> createMembershipAsync(CreateMembershipRequest request) {

        return createMembershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateMembershipResult> createMembershipAsync(CreateMembershipRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateMembershipRequest, CreateMembershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteCollaborationResult> deleteCollaborationAsync(DeleteCollaborationRequest request) {

        return deleteCollaborationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteCollaborationResult> deleteCollaborationAsync(DeleteCollaborationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteCollaborationRequest, DeleteCollaborationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredTableResult> deleteConfiguredTableAsync(DeleteConfiguredTableRequest request) {

        return deleteConfiguredTableAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredTableResult> deleteConfiguredTableAsync(DeleteConfiguredTableRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteConfiguredTableRequest, DeleteConfiguredTableResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredTableAnalysisRuleResult> deleteConfiguredTableAnalysisRuleAsync(
            DeleteConfiguredTableAnalysisRuleRequest request) {

        return deleteConfiguredTableAnalysisRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredTableAnalysisRuleResult> deleteConfiguredTableAnalysisRuleAsync(
            DeleteConfiguredTableAnalysisRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteConfiguredTableAnalysisRuleRequest, DeleteConfiguredTableAnalysisRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredTableAssociationResult> deleteConfiguredTableAssociationAsync(
            DeleteConfiguredTableAssociationRequest request) {

        return deleteConfiguredTableAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredTableAssociationResult> deleteConfiguredTableAssociationAsync(
            DeleteConfiguredTableAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteConfiguredTableAssociationRequest, DeleteConfiguredTableAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteMemberResult> deleteMemberAsync(DeleteMemberRequest request) {

        return deleteMemberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteMemberResult> deleteMemberAsync(DeleteMemberRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteMemberRequest, DeleteMemberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteMembershipResult> deleteMembershipAsync(DeleteMembershipRequest request) {

        return deleteMembershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteMembershipResult> deleteMembershipAsync(DeleteMembershipRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteMembershipRequest, DeleteMembershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetCollaborationResult> getCollaborationAsync(GetCollaborationRequest request) {

        return getCollaborationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetCollaborationResult> getCollaborationAsync(GetCollaborationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetCollaborationRequest, GetCollaborationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredTableResult> getConfiguredTableAsync(GetConfiguredTableRequest request) {

        return getConfiguredTableAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredTableResult> getConfiguredTableAsync(GetConfiguredTableRequest request,
            com.amazonaws.handlers.AsyncHandler<GetConfiguredTableRequest, GetConfiguredTableResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredTableAnalysisRuleResult> getConfiguredTableAnalysisRuleAsync(GetConfiguredTableAnalysisRuleRequest request) {

        return getConfiguredTableAnalysisRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredTableAnalysisRuleResult> getConfiguredTableAnalysisRuleAsync(GetConfiguredTableAnalysisRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<GetConfiguredTableAnalysisRuleRequest, GetConfiguredTableAnalysisRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredTableAssociationResult> getConfiguredTableAssociationAsync(GetConfiguredTableAssociationRequest request) {

        return getConfiguredTableAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredTableAssociationResult> getConfiguredTableAssociationAsync(GetConfiguredTableAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetConfiguredTableAssociationRequest, GetConfiguredTableAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMembershipResult> getMembershipAsync(GetMembershipRequest request) {

        return getMembershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMembershipResult> getMembershipAsync(GetMembershipRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMembershipRequest, GetMembershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetProtectedQueryResult> getProtectedQueryAsync(GetProtectedQueryRequest request) {

        return getProtectedQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetProtectedQueryResult> getProtectedQueryAsync(GetProtectedQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetProtectedQueryRequest, GetProtectedQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSchemaResult> getSchemaAsync(GetSchemaRequest request) {

        return getSchemaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSchemaResult> getSchemaAsync(GetSchemaRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSchemaRequest, GetSchemaResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSchemaAnalysisRuleResult> getSchemaAnalysisRuleAsync(GetSchemaAnalysisRuleRequest request) {

        return getSchemaAnalysisRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSchemaAnalysisRuleResult> getSchemaAnalysisRuleAsync(GetSchemaAnalysisRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSchemaAnalysisRuleRequest, GetSchemaAnalysisRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListCollaborationsResult> listCollaborationsAsync(ListCollaborationsRequest request) {

        return listCollaborationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListCollaborationsResult> listCollaborationsAsync(ListCollaborationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListCollaborationsRequest, ListCollaborationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListConfiguredTableAssociationsResult> listConfiguredTableAssociationsAsync(
            ListConfiguredTableAssociationsRequest request) {

        return listConfiguredTableAssociationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListConfiguredTableAssociationsResult> listConfiguredTableAssociationsAsync(
            ListConfiguredTableAssociationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListConfiguredTableAssociationsRequest, ListConfiguredTableAssociationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListConfiguredTablesResult> listConfiguredTablesAsync(ListConfiguredTablesRequest request) {

        return listConfiguredTablesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListConfiguredTablesResult> listConfiguredTablesAsync(ListConfiguredTablesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListConfiguredTablesRequest, ListConfiguredTablesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMembersResult> listMembersAsync(ListMembersRequest request) {

        return listMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMembersResult> listMembersAsync(ListMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMembersRequest, ListMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMembershipsResult> listMembershipsAsync(ListMembershipsRequest request) {

        return listMembershipsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMembershipsResult> listMembershipsAsync(ListMembershipsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMembershipsRequest, ListMembershipsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProtectedQueriesResult> listProtectedQueriesAsync(ListProtectedQueriesRequest request) {

        return listProtectedQueriesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProtectedQueriesResult> listProtectedQueriesAsync(ListProtectedQueriesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProtectedQueriesRequest, ListProtectedQueriesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSchemasResult> listSchemasAsync(ListSchemasRequest request) {

        return listSchemasAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSchemasResult> listSchemasAsync(ListSchemasRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSchemasRequest, ListSchemasResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartProtectedQueryResult> startProtectedQueryAsync(StartProtectedQueryRequest request) {

        return startProtectedQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartProtectedQueryResult> startProtectedQueryAsync(StartProtectedQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<StartProtectedQueryRequest, StartProtectedQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateCollaborationResult> updateCollaborationAsync(UpdateCollaborationRequest request) {

        return updateCollaborationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateCollaborationResult> updateCollaborationAsync(UpdateCollaborationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateCollaborationRequest, UpdateCollaborationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateConfiguredTableResult> updateConfiguredTableAsync(UpdateConfiguredTableRequest request) {

        return updateConfiguredTableAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateConfiguredTableResult> updateConfiguredTableAsync(UpdateConfiguredTableRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateConfiguredTableRequest, UpdateConfiguredTableResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateConfiguredTableAnalysisRuleResult> updateConfiguredTableAnalysisRuleAsync(
            UpdateConfiguredTableAnalysisRuleRequest request) {

        return updateConfiguredTableAnalysisRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateConfiguredTableAnalysisRuleResult> updateConfiguredTableAnalysisRuleAsync(
            UpdateConfiguredTableAnalysisRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateConfiguredTableAnalysisRuleRequest, UpdateConfiguredTableAnalysisRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateConfiguredTableAssociationResult> updateConfiguredTableAssociationAsync(
            UpdateConfiguredTableAssociationRequest request) {

        return updateConfiguredTableAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateConfiguredTableAssociationResult> updateConfiguredTableAssociationAsync(
            UpdateConfiguredTableAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateConfiguredTableAssociationRequest, UpdateConfiguredTableAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateMembershipResult> updateMembershipAsync(UpdateMembershipRequest request) {

        return updateMembershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateMembershipResult> updateMembershipAsync(UpdateMembershipRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateMembershipRequest, UpdateMembershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateProtectedQueryResult> updateProtectedQueryAsync(UpdateProtectedQueryRequest request) {

        return updateProtectedQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateProtectedQueryResult> updateProtectedQueryAsync(UpdateProtectedQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateProtectedQueryRequest, UpdateProtectedQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
