/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkmeetings.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.chimesdkmeetings.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Meeting JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MeetingJsonUnmarshaller implements Unmarshaller<Meeting, JsonUnmarshallerContext> {

    public Meeting unmarshall(JsonUnmarshallerContext context) throws Exception {
        Meeting meeting = new Meeting();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("MeetingId", targetDepth)) {
                    context.nextToken();
                    meeting.setMeetingId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MeetingHostId", targetDepth)) {
                    context.nextToken();
                    meeting.setMeetingHostId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExternalMeetingId", targetDepth)) {
                    context.nextToken();
                    meeting.setExternalMeetingId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MediaRegion", targetDepth)) {
                    context.nextToken();
                    meeting.setMediaRegion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MediaPlacement", targetDepth)) {
                    context.nextToken();
                    meeting.setMediaPlacement(MediaPlacementJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MeetingFeatures", targetDepth)) {
                    context.nextToken();
                    meeting.setMeetingFeatures(MeetingFeaturesConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PrimaryMeetingId", targetDepth)) {
                    context.nextToken();
                    meeting.setPrimaryMeetingId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TenantIds", targetDepth)) {
                    context.nextToken();
                    meeting.setTenantIds(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return meeting;
    }

    private static MeetingJsonUnmarshaller instance;

    public static MeetingJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new MeetingJsonUnmarshaller();
        return instance;
    }
}
