/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkidentity;

import javax.annotation.Generated;

import com.amazonaws.services.chimesdkidentity.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonChimeSDKIdentity}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonChimeSDKIdentity implements AmazonChimeSDKIdentity {

    protected AbstractAmazonChimeSDKIdentity() {
    }

    @Override
    public CreateAppInstanceResult createAppInstance(CreateAppInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppInstanceAdminResult createAppInstanceAdmin(CreateAppInstanceAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppInstanceBotResult createAppInstanceBot(CreateAppInstanceBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppInstanceUserResult createAppInstanceUser(CreateAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInstanceResult deleteAppInstance(DeleteAppInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInstanceAdminResult deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInstanceBotResult deleteAppInstanceBot(DeleteAppInstanceBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInstanceUserResult deleteAppInstanceUser(DeleteAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterAppInstanceUserEndpointResult deregisterAppInstanceUserEndpoint(DeregisterAppInstanceUserEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppInstanceResult describeAppInstance(DescribeAppInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppInstanceAdminResult describeAppInstanceAdmin(DescribeAppInstanceAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppInstanceBotResult describeAppInstanceBot(DescribeAppInstanceBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppInstanceUserResult describeAppInstanceUser(DescribeAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppInstanceUserEndpointResult describeAppInstanceUserEndpoint(DescribeAppInstanceUserEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppInstanceRetentionSettingsResult getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInstanceAdminsResult listAppInstanceAdmins(ListAppInstanceAdminsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInstanceBotsResult listAppInstanceBots(ListAppInstanceBotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInstanceUserEndpointsResult listAppInstanceUserEndpoints(ListAppInstanceUserEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInstanceUsersResult listAppInstanceUsers(ListAppInstanceUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInstancesResult listAppInstances(ListAppInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutAppInstanceRetentionSettingsResult putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutAppInstanceUserExpirationSettingsResult putAppInstanceUserExpirationSettings(PutAppInstanceUserExpirationSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterAppInstanceUserEndpointResult registerAppInstanceUserEndpoint(RegisterAppInstanceUserEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppInstanceResult updateAppInstance(UpdateAppInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppInstanceBotResult updateAppInstanceBot(UpdateAppInstanceBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppInstanceUserResult updateAppInstanceUser(UpdateAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppInstanceUserEndpointResult updateAppInstanceUserEndpoint(UpdateAppInstanceUserEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
