/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkidentity;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.chimesdkidentity.AmazonChimeSDKIdentity;
import com.amazonaws.services.chimesdkidentity.AmazonChimeSDKIdentityClientBuilder;
import com.amazonaws.services.chimesdkidentity.model.AmazonChimeSDKIdentityException;
import com.amazonaws.services.chimesdkidentity.model.CreateAppInstanceAdminRequest;
import com.amazonaws.services.chimesdkidentity.model.CreateAppInstanceAdminResult;
import com.amazonaws.services.chimesdkidentity.model.CreateAppInstanceRequest;
import com.amazonaws.services.chimesdkidentity.model.CreateAppInstanceResult;
import com.amazonaws.services.chimesdkidentity.model.CreateAppInstanceUserRequest;
import com.amazonaws.services.chimesdkidentity.model.CreateAppInstanceUserResult;
import com.amazonaws.services.chimesdkidentity.model.DeleteAppInstanceAdminRequest;
import com.amazonaws.services.chimesdkidentity.model.DeleteAppInstanceAdminResult;
import com.amazonaws.services.chimesdkidentity.model.DeleteAppInstanceRequest;
import com.amazonaws.services.chimesdkidentity.model.DeleteAppInstanceResult;
import com.amazonaws.services.chimesdkidentity.model.DeleteAppInstanceUserRequest;
import com.amazonaws.services.chimesdkidentity.model.DeleteAppInstanceUserResult;
import com.amazonaws.services.chimesdkidentity.model.DeregisterAppInstanceUserEndpointRequest;
import com.amazonaws.services.chimesdkidentity.model.DeregisterAppInstanceUserEndpointResult;
import com.amazonaws.services.chimesdkidentity.model.DescribeAppInstanceAdminRequest;
import com.amazonaws.services.chimesdkidentity.model.DescribeAppInstanceAdminResult;
import com.amazonaws.services.chimesdkidentity.model.DescribeAppInstanceRequest;
import com.amazonaws.services.chimesdkidentity.model.DescribeAppInstanceResult;
import com.amazonaws.services.chimesdkidentity.model.DescribeAppInstanceUserEndpointRequest;
import com.amazonaws.services.chimesdkidentity.model.DescribeAppInstanceUserEndpointResult;
import com.amazonaws.services.chimesdkidentity.model.DescribeAppInstanceUserRequest;
import com.amazonaws.services.chimesdkidentity.model.DescribeAppInstanceUserResult;
import com.amazonaws.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsRequest;
import com.amazonaws.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsResult;
import com.amazonaws.services.chimesdkidentity.model.ListAppInstanceAdminsRequest;
import com.amazonaws.services.chimesdkidentity.model.ListAppInstanceAdminsResult;
import com.amazonaws.services.chimesdkidentity.model.ListAppInstanceUserEndpointsRequest;
import com.amazonaws.services.chimesdkidentity.model.ListAppInstanceUserEndpointsResult;
import com.amazonaws.services.chimesdkidentity.model.ListAppInstanceUsersRequest;
import com.amazonaws.services.chimesdkidentity.model.ListAppInstanceUsersResult;
import com.amazonaws.services.chimesdkidentity.model.ListAppInstancesRequest;
import com.amazonaws.services.chimesdkidentity.model.ListAppInstancesResult;
import com.amazonaws.services.chimesdkidentity.model.ListTagsForResourceRequest;
import com.amazonaws.services.chimesdkidentity.model.ListTagsForResourceResult;
import com.amazonaws.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsRequest;
import com.amazonaws.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsResult;
import com.amazonaws.services.chimesdkidentity.model.RegisterAppInstanceUserEndpointRequest;
import com.amazonaws.services.chimesdkidentity.model.RegisterAppInstanceUserEndpointResult;
import com.amazonaws.services.chimesdkidentity.model.TagResourceRequest;
import com.amazonaws.services.chimesdkidentity.model.TagResourceResult;
import com.amazonaws.services.chimesdkidentity.model.UntagResourceRequest;
import com.amazonaws.services.chimesdkidentity.model.UntagResourceResult;
import com.amazonaws.services.chimesdkidentity.model.UpdateAppInstanceRequest;
import com.amazonaws.services.chimesdkidentity.model.UpdateAppInstanceResult;
import com.amazonaws.services.chimesdkidentity.model.UpdateAppInstanceUserEndpointRequest;
import com.amazonaws.services.chimesdkidentity.model.UpdateAppInstanceUserEndpointResult;
import com.amazonaws.services.chimesdkidentity.model.UpdateAppInstanceUserRequest;
import com.amazonaws.services.chimesdkidentity.model.UpdateAppInstanceUserResult;
import com.amazonaws.services.chimesdkidentity.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.CreateAppInstanceAdminRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.CreateAppInstanceAdminResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.CreateAppInstanceRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.CreateAppInstanceResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.CreateAppInstanceUserRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.CreateAppInstanceUserResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DeleteAppInstanceAdminRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DeleteAppInstanceAdminResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DeleteAppInstanceRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DeleteAppInstanceResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DeleteAppInstanceUserRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DeleteAppInstanceUserResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DeregisterAppInstanceUserEndpointRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DeregisterAppInstanceUserEndpointResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DescribeAppInstanceAdminRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DescribeAppInstanceAdminResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DescribeAppInstanceRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DescribeAppInstanceResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DescribeAppInstanceUserEndpointRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DescribeAppInstanceUserEndpointResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DescribeAppInstanceUserRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.DescribeAppInstanceUserResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.GetAppInstanceRetentionSettingsRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.GetAppInstanceRetentionSettingsResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListAppInstanceAdminsRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListAppInstanceAdminsResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListAppInstanceUserEndpointsRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListAppInstanceUserEndpointsResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListAppInstanceUsersRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListAppInstanceUsersResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListAppInstancesRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListAppInstancesResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.PutAppInstanceRetentionSettingsRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.PutAppInstanceRetentionSettingsResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.RegisterAppInstanceUserEndpointRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.RegisterAppInstanceUserEndpointResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ResourceLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ServiceFailureExceptionUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.ThrottledClientExceptionUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UnauthorizedClientExceptionUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UpdateAppInstanceRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UpdateAppInstanceResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UpdateAppInstanceUserEndpointRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UpdateAppInstanceUserEndpointResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UpdateAppInstanceUserRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkidentity.model.transform.UpdateAppInstanceUserResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonChimeSDKIdentityClient
extends AmazonWebServiceClient
implements AmazonChimeSDKIdentity {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonChimeSDKIdentity.class);
    private static final String DEFAULT_SIGNING_NAME = "chime";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedClientException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnauthorizedClientExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottledClientException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottledClientExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceFailureExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonChimeSDKIdentityException.class));

    public static AmazonChimeSDKIdentityClientBuilder builder() {
        return AmazonChimeSDKIdentityClientBuilder.standard();
    }

    AmazonChimeSDKIdentityClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonChimeSDKIdentityClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("identity-chime");
        this.setEndpoint("identity-chime.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/chimesdkidentity/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/chimesdkidentity/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateAppInstanceResult createAppInstance(CreateAppInstanceRequest request) {
        request = (CreateAppInstanceRequest)this.beforeClientExecution(request);
        return this.executeCreateAppInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAppInstanceResult executeCreateAppInstance(CreateAppInstanceRequest createAppInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAppInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAppInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAppInstanceRequestProtocolMarshaller(protocolFactory).marshall((CreateAppInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAppInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAppInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAppInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAppInstanceResult createAppInstanceResult = (CreateAppInstanceResult)response.getAwsResponse();
            return createAppInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAppInstanceAdminResult createAppInstanceAdmin(CreateAppInstanceAdminRequest request) {
        request = (CreateAppInstanceAdminRequest)this.beforeClientExecution(request);
        return this.executeCreateAppInstanceAdmin(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAppInstanceAdminResult executeCreateAppInstanceAdmin(CreateAppInstanceAdminRequest createAppInstanceAdminRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAppInstanceAdminRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAppInstanceAdminRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAppInstanceAdminRequestProtocolMarshaller(protocolFactory).marshall((CreateAppInstanceAdminRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAppInstanceAdminRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAppInstanceAdmin");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAppInstanceAdminResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAppInstanceAdminResult createAppInstanceAdminResult = (CreateAppInstanceAdminResult)response.getAwsResponse();
            return createAppInstanceAdminResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAppInstanceUserResult createAppInstanceUser(CreateAppInstanceUserRequest request) {
        request = (CreateAppInstanceUserRequest)this.beforeClientExecution(request);
        return this.executeCreateAppInstanceUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAppInstanceUserResult executeCreateAppInstanceUser(CreateAppInstanceUserRequest createAppInstanceUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAppInstanceUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAppInstanceUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAppInstanceUserRequestProtocolMarshaller(protocolFactory).marshall((CreateAppInstanceUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAppInstanceUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAppInstanceUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAppInstanceUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAppInstanceUserResult createAppInstanceUserResult = (CreateAppInstanceUserResult)response.getAwsResponse();
            return createAppInstanceUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAppInstanceResult deleteAppInstance(DeleteAppInstanceRequest request) {
        request = (DeleteAppInstanceRequest)this.beforeClientExecution(request);
        return this.executeDeleteAppInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAppInstanceResult executeDeleteAppInstance(DeleteAppInstanceRequest deleteAppInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAppInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAppInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAppInstanceRequestProtocolMarshaller(protocolFactory).marshall((DeleteAppInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAppInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAppInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAppInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAppInstanceResult deleteAppInstanceResult = (DeleteAppInstanceResult)response.getAwsResponse();
            return deleteAppInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAppInstanceAdminResult deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest request) {
        request = (DeleteAppInstanceAdminRequest)this.beforeClientExecution(request);
        return this.executeDeleteAppInstanceAdmin(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAppInstanceAdminResult executeDeleteAppInstanceAdmin(DeleteAppInstanceAdminRequest deleteAppInstanceAdminRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAppInstanceAdminRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAppInstanceAdminRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAppInstanceAdminRequestProtocolMarshaller(protocolFactory).marshall((DeleteAppInstanceAdminRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAppInstanceAdminRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAppInstanceAdmin");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAppInstanceAdminResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAppInstanceAdminResult deleteAppInstanceAdminResult = (DeleteAppInstanceAdminResult)response.getAwsResponse();
            return deleteAppInstanceAdminResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAppInstanceUserResult deleteAppInstanceUser(DeleteAppInstanceUserRequest request) {
        request = (DeleteAppInstanceUserRequest)this.beforeClientExecution(request);
        return this.executeDeleteAppInstanceUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAppInstanceUserResult executeDeleteAppInstanceUser(DeleteAppInstanceUserRequest deleteAppInstanceUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAppInstanceUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAppInstanceUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAppInstanceUserRequestProtocolMarshaller(protocolFactory).marshall((DeleteAppInstanceUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAppInstanceUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAppInstanceUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAppInstanceUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAppInstanceUserResult deleteAppInstanceUserResult = (DeleteAppInstanceUserResult)response.getAwsResponse();
            return deleteAppInstanceUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterAppInstanceUserEndpointResult deregisterAppInstanceUserEndpoint(DeregisterAppInstanceUserEndpointRequest request) {
        request = (DeregisterAppInstanceUserEndpointRequest)this.beforeClientExecution(request);
        return this.executeDeregisterAppInstanceUserEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterAppInstanceUserEndpointResult executeDeregisterAppInstanceUserEndpoint(DeregisterAppInstanceUserEndpointRequest deregisterAppInstanceUserEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterAppInstanceUserEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterAppInstanceUserEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterAppInstanceUserEndpointRequestProtocolMarshaller(protocolFactory).marshall((DeregisterAppInstanceUserEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterAppInstanceUserEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeregisterAppInstanceUserEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterAppInstanceUserEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterAppInstanceUserEndpointResult deregisterAppInstanceUserEndpointResult = (DeregisterAppInstanceUserEndpointResult)response.getAwsResponse();
            return deregisterAppInstanceUserEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAppInstanceResult describeAppInstance(DescribeAppInstanceRequest request) {
        request = (DescribeAppInstanceRequest)this.beforeClientExecution(request);
        return this.executeDescribeAppInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAppInstanceResult executeDescribeAppInstance(DescribeAppInstanceRequest describeAppInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAppInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAppInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAppInstanceRequestProtocolMarshaller(protocolFactory).marshall((DescribeAppInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAppInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAppInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAppInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAppInstanceResult describeAppInstanceResult = (DescribeAppInstanceResult)response.getAwsResponse();
            return describeAppInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAppInstanceAdminResult describeAppInstanceAdmin(DescribeAppInstanceAdminRequest request) {
        request = (DescribeAppInstanceAdminRequest)this.beforeClientExecution(request);
        return this.executeDescribeAppInstanceAdmin(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAppInstanceAdminResult executeDescribeAppInstanceAdmin(DescribeAppInstanceAdminRequest describeAppInstanceAdminRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAppInstanceAdminRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAppInstanceAdminRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAppInstanceAdminRequestProtocolMarshaller(protocolFactory).marshall((DescribeAppInstanceAdminRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAppInstanceAdminRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAppInstanceAdmin");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAppInstanceAdminResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAppInstanceAdminResult describeAppInstanceAdminResult = (DescribeAppInstanceAdminResult)response.getAwsResponse();
            return describeAppInstanceAdminResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAppInstanceUserResult describeAppInstanceUser(DescribeAppInstanceUserRequest request) {
        request = (DescribeAppInstanceUserRequest)this.beforeClientExecution(request);
        return this.executeDescribeAppInstanceUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAppInstanceUserResult executeDescribeAppInstanceUser(DescribeAppInstanceUserRequest describeAppInstanceUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAppInstanceUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAppInstanceUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAppInstanceUserRequestProtocolMarshaller(protocolFactory).marshall((DescribeAppInstanceUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAppInstanceUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAppInstanceUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAppInstanceUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAppInstanceUserResult describeAppInstanceUserResult = (DescribeAppInstanceUserResult)response.getAwsResponse();
            return describeAppInstanceUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAppInstanceUserEndpointResult describeAppInstanceUserEndpoint(DescribeAppInstanceUserEndpointRequest request) {
        request = (DescribeAppInstanceUserEndpointRequest)this.beforeClientExecution(request);
        return this.executeDescribeAppInstanceUserEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAppInstanceUserEndpointResult executeDescribeAppInstanceUserEndpoint(DescribeAppInstanceUserEndpointRequest describeAppInstanceUserEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAppInstanceUserEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAppInstanceUserEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAppInstanceUserEndpointRequestProtocolMarshaller(protocolFactory).marshall((DescribeAppInstanceUserEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAppInstanceUserEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAppInstanceUserEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAppInstanceUserEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAppInstanceUserEndpointResult describeAppInstanceUserEndpointResult = (DescribeAppInstanceUserEndpointResult)response.getAwsResponse();
            return describeAppInstanceUserEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAppInstanceRetentionSettingsResult getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest request) {
        request = (GetAppInstanceRetentionSettingsRequest)this.beforeClientExecution(request);
        return this.executeGetAppInstanceRetentionSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAppInstanceRetentionSettingsResult executeGetAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest getAppInstanceRetentionSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAppInstanceRetentionSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAppInstanceRetentionSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAppInstanceRetentionSettingsRequestProtocolMarshaller(protocolFactory).marshall((GetAppInstanceRetentionSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAppInstanceRetentionSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAppInstanceRetentionSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAppInstanceRetentionSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAppInstanceRetentionSettingsResult getAppInstanceRetentionSettingsResult = (GetAppInstanceRetentionSettingsResult)response.getAwsResponse();
            return getAppInstanceRetentionSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAppInstanceAdminsResult listAppInstanceAdmins(ListAppInstanceAdminsRequest request) {
        request = (ListAppInstanceAdminsRequest)this.beforeClientExecution(request);
        return this.executeListAppInstanceAdmins(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAppInstanceAdminsResult executeListAppInstanceAdmins(ListAppInstanceAdminsRequest listAppInstanceAdminsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAppInstanceAdminsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAppInstanceAdminsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAppInstanceAdminsRequestProtocolMarshaller(protocolFactory).marshall((ListAppInstanceAdminsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAppInstanceAdminsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAppInstanceAdmins");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAppInstanceAdminsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAppInstanceAdminsResult listAppInstanceAdminsResult = (ListAppInstanceAdminsResult)response.getAwsResponse();
            return listAppInstanceAdminsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAppInstanceUserEndpointsResult listAppInstanceUserEndpoints(ListAppInstanceUserEndpointsRequest request) {
        request = (ListAppInstanceUserEndpointsRequest)this.beforeClientExecution(request);
        return this.executeListAppInstanceUserEndpoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAppInstanceUserEndpointsResult executeListAppInstanceUserEndpoints(ListAppInstanceUserEndpointsRequest listAppInstanceUserEndpointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAppInstanceUserEndpointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAppInstanceUserEndpointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAppInstanceUserEndpointsRequestProtocolMarshaller(protocolFactory).marshall((ListAppInstanceUserEndpointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAppInstanceUserEndpointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAppInstanceUserEndpoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAppInstanceUserEndpointsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAppInstanceUserEndpointsResult listAppInstanceUserEndpointsResult = (ListAppInstanceUserEndpointsResult)response.getAwsResponse();
            return listAppInstanceUserEndpointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAppInstanceUsersResult listAppInstanceUsers(ListAppInstanceUsersRequest request) {
        request = (ListAppInstanceUsersRequest)this.beforeClientExecution(request);
        return this.executeListAppInstanceUsers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAppInstanceUsersResult executeListAppInstanceUsers(ListAppInstanceUsersRequest listAppInstanceUsersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAppInstanceUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAppInstanceUsersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAppInstanceUsersRequestProtocolMarshaller(protocolFactory).marshall((ListAppInstanceUsersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAppInstanceUsersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAppInstanceUsers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAppInstanceUsersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAppInstanceUsersResult listAppInstanceUsersResult = (ListAppInstanceUsersResult)response.getAwsResponse();
            return listAppInstanceUsersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAppInstancesResult listAppInstances(ListAppInstancesRequest request) {
        request = (ListAppInstancesRequest)this.beforeClientExecution(request);
        return this.executeListAppInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAppInstancesResult executeListAppInstances(ListAppInstancesRequest listAppInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAppInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAppInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAppInstancesRequestProtocolMarshaller(protocolFactory).marshall((ListAppInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAppInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAppInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAppInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAppInstancesResult listAppInstancesResult = (ListAppInstancesResult)response.getAwsResponse();
            return listAppInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutAppInstanceRetentionSettingsResult putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest request) {
        request = (PutAppInstanceRetentionSettingsRequest)this.beforeClientExecution(request);
        return this.executePutAppInstanceRetentionSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAppInstanceRetentionSettingsResult executePutAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest putAppInstanceRetentionSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAppInstanceRetentionSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAppInstanceRetentionSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAppInstanceRetentionSettingsRequestProtocolMarshaller(protocolFactory).marshall((PutAppInstanceRetentionSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAppInstanceRetentionSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAppInstanceRetentionSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutAppInstanceRetentionSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutAppInstanceRetentionSettingsResult putAppInstanceRetentionSettingsResult = (PutAppInstanceRetentionSettingsResult)response.getAwsResponse();
            return putAppInstanceRetentionSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterAppInstanceUserEndpointResult registerAppInstanceUserEndpoint(RegisterAppInstanceUserEndpointRequest request) {
        request = (RegisterAppInstanceUserEndpointRequest)this.beforeClientExecution(request);
        return this.executeRegisterAppInstanceUserEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterAppInstanceUserEndpointResult executeRegisterAppInstanceUserEndpoint(RegisterAppInstanceUserEndpointRequest registerAppInstanceUserEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerAppInstanceUserEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterAppInstanceUserEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterAppInstanceUserEndpointRequestProtocolMarshaller(protocolFactory).marshall((RegisterAppInstanceUserEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerAppInstanceUserEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterAppInstanceUserEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterAppInstanceUserEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterAppInstanceUserEndpointResult registerAppInstanceUserEndpointResult = (RegisterAppInstanceUserEndpointResult)response.getAwsResponse();
            return registerAppInstanceUserEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAppInstanceResult updateAppInstance(UpdateAppInstanceRequest request) {
        request = (UpdateAppInstanceRequest)this.beforeClientExecution(request);
        return this.executeUpdateAppInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAppInstanceResult executeUpdateAppInstance(UpdateAppInstanceRequest updateAppInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAppInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAppInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAppInstanceRequestProtocolMarshaller(protocolFactory).marshall((UpdateAppInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAppInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAppInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAppInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAppInstanceResult updateAppInstanceResult = (UpdateAppInstanceResult)response.getAwsResponse();
            return updateAppInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAppInstanceUserResult updateAppInstanceUser(UpdateAppInstanceUserRequest request) {
        request = (UpdateAppInstanceUserRequest)this.beforeClientExecution(request);
        return this.executeUpdateAppInstanceUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAppInstanceUserResult executeUpdateAppInstanceUser(UpdateAppInstanceUserRequest updateAppInstanceUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAppInstanceUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAppInstanceUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAppInstanceUserRequestProtocolMarshaller(protocolFactory).marshall((UpdateAppInstanceUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAppInstanceUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAppInstanceUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAppInstanceUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAppInstanceUserResult updateAppInstanceUserResult = (UpdateAppInstanceUserResult)response.getAwsResponse();
            return updateAppInstanceUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAppInstanceUserEndpointResult updateAppInstanceUserEndpoint(UpdateAppInstanceUserEndpointRequest request) {
        request = (UpdateAppInstanceUserEndpointRequest)this.beforeClientExecution(request);
        return this.executeUpdateAppInstanceUserEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAppInstanceUserEndpointResult executeUpdateAppInstanceUserEndpoint(UpdateAppInstanceUserEndpointRequest updateAppInstanceUserEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAppInstanceUserEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAppInstanceUserEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAppInstanceUserEndpointRequestProtocolMarshaller(protocolFactory).marshall((UpdateAppInstanceUserEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAppInstanceUserEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Identity");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAppInstanceUserEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAppInstanceUserEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAppInstanceUserEndpointResult updateAppInstanceUserEndpointResult = (UpdateAppInstanceUserEndpointResult)response.getAwsResponse();
            return updateAppInstanceUserEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

