/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chime.model.PhoneNumberType;
import com.amazonaws.services.chime.model.transform.PhoneNumberCountryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PhoneNumberCountry
implements Serializable,
Cloneable,
StructuredPojo {
    private String countryCode;
    private List<String> supportedPhoneNumberTypes;

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public PhoneNumberCountry withCountryCode(String countryCode) {
        this.setCountryCode(countryCode);
        return this;
    }

    public List<String> getSupportedPhoneNumberTypes() {
        return this.supportedPhoneNumberTypes;
    }

    public void setSupportedPhoneNumberTypes(Collection<String> supportedPhoneNumberTypes) {
        if (supportedPhoneNumberTypes == null) {
            this.supportedPhoneNumberTypes = null;
            return;
        }
        this.supportedPhoneNumberTypes = new ArrayList<String>(supportedPhoneNumberTypes);
    }

    public PhoneNumberCountry withSupportedPhoneNumberTypes(String ... supportedPhoneNumberTypes) {
        if (this.supportedPhoneNumberTypes == null) {
            this.setSupportedPhoneNumberTypes(new ArrayList<String>(supportedPhoneNumberTypes.length));
        }
        for (String ele : supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypes.add(ele);
        }
        return this;
    }

    public PhoneNumberCountry withSupportedPhoneNumberTypes(Collection<String> supportedPhoneNumberTypes) {
        this.setSupportedPhoneNumberTypes(supportedPhoneNumberTypes);
        return this;
    }

    public PhoneNumberCountry withSupportedPhoneNumberTypes(PhoneNumberType ... supportedPhoneNumberTypes) {
        ArrayList<String> supportedPhoneNumberTypesCopy = new ArrayList<String>(supportedPhoneNumberTypes.length);
        for (PhoneNumberType value : supportedPhoneNumberTypes) {
            supportedPhoneNumberTypesCopy.add(value.toString());
        }
        if (this.getSupportedPhoneNumberTypes() == null) {
            this.setSupportedPhoneNumberTypes(supportedPhoneNumberTypesCopy);
        } else {
            this.getSupportedPhoneNumberTypes().addAll(supportedPhoneNumberTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCountryCode() != null) {
            sb.append("CountryCode: ").append(this.getCountryCode()).append(",");
        }
        if (this.getSupportedPhoneNumberTypes() != null) {
            sb.append("SupportedPhoneNumberTypes: ").append(this.getSupportedPhoneNumberTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberCountry)) {
            return false;
        }
        PhoneNumberCountry other = (PhoneNumberCountry)obj;
        if (other.getCountryCode() == null ^ this.getCountryCode() == null) {
            return false;
        }
        if (other.getCountryCode() != null && !other.getCountryCode().equals(this.getCountryCode())) {
            return false;
        }
        if (other.getSupportedPhoneNumberTypes() == null ^ this.getSupportedPhoneNumberTypes() == null) {
            return false;
        }
        return other.getSupportedPhoneNumberTypes() == null || other.getSupportedPhoneNumberTypes().equals(this.getSupportedPhoneNumberTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCountryCode() == null ? 0 : this.getCountryCode().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedPhoneNumberTypes() == null ? 0 : this.getSupportedPhoneNumberTypes().hashCode());
        return hashCode;
    }

    public PhoneNumberCountry clone() {
        try {
            return (PhoneNumberCountry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PhoneNumberCountryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

