/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chime.model.CreateAttendeeRequestItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchCreateAttendeeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String meetingId;
    private List<CreateAttendeeRequestItem> attendees;

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public BatchCreateAttendeeRequest withMeetingId(String meetingId) {
        this.setMeetingId(meetingId);
        return this;
    }

    public List<CreateAttendeeRequestItem> getAttendees() {
        return this.attendees;
    }

    public void setAttendees(Collection<CreateAttendeeRequestItem> attendees) {
        if (attendees == null) {
            this.attendees = null;
            return;
        }
        this.attendees = new ArrayList<CreateAttendeeRequestItem>(attendees);
    }

    public BatchCreateAttendeeRequest withAttendees(CreateAttendeeRequestItem ... attendees) {
        if (this.attendees == null) {
            this.setAttendees(new ArrayList<CreateAttendeeRequestItem>(attendees.length));
        }
        for (CreateAttendeeRequestItem ele : attendees) {
            this.attendees.add(ele);
        }
        return this;
    }

    public BatchCreateAttendeeRequest withAttendees(Collection<CreateAttendeeRequestItem> attendees) {
        this.setAttendees(attendees);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMeetingId() != null) {
            sb.append("MeetingId: ").append(this.getMeetingId()).append(",");
        }
        if (this.getAttendees() != null) {
            sb.append("Attendees: ").append(this.getAttendees());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateAttendeeRequest)) {
            return false;
        }
        BatchCreateAttendeeRequest other = (BatchCreateAttendeeRequest)obj;
        if (other.getMeetingId() == null ^ this.getMeetingId() == null) {
            return false;
        }
        if (other.getMeetingId() != null && !other.getMeetingId().equals(this.getMeetingId())) {
            return false;
        }
        if (other.getAttendees() == null ^ this.getAttendees() == null) {
            return false;
        }
        return other.getAttendees() == null || other.getAttendees().equals(this.getAttendees());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMeetingId() == null ? 0 : this.getMeetingId().hashCode());
        hashCode = 31 * hashCode + (this.getAttendees() == null ? 0 : this.getAttendees().hashCode());
        return hashCode;
    }

    public BatchCreateAttendeeRequest clone() {
        return (BatchCreateAttendeeRequest)super.clone();
    }
}

