/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.chime.model.Account;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAccountsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Account> accounts;
    private String nextToken;

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Collection<Account> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }
        this.accounts = new ArrayList<Account>(accounts);
    }

    public ListAccountsResult withAccounts(Account ... accounts) {
        if (this.accounts == null) {
            this.setAccounts(new ArrayList<Account>(accounts.length));
        }
        for (Account ele : accounts) {
            this.accounts.add(ele);
        }
        return this;
    }

    public ListAccountsResult withAccounts(Collection<Account> accounts) {
        this.setAccounts(accounts);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAccountsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccounts() != null) {
            sb.append("Accounts: ").append(this.getAccounts()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsResult)) {
            return false;
        }
        ListAccountsResult other = (ListAccountsResult)obj;
        if (other.getAccounts() == null ^ this.getAccounts() == null) {
            return false;
        }
        if (other.getAccounts() != null && !other.getAccounts().equals(this.getAccounts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccounts() == null ? 0 : this.getAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAccountsResult clone() {
        try {
            return (ListAccountsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

