/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.chime.AmazonChimeAsync;
import com.amazonaws.services.chime.AmazonChimeAsyncClientBuilder;
import com.amazonaws.services.chime.AmazonChimeClient;
import com.amazonaws.services.chime.model.BatchSuspendUserRequest;
import com.amazonaws.services.chime.model.BatchSuspendUserResult;
import com.amazonaws.services.chime.model.BatchUnsuspendUserRequest;
import com.amazonaws.services.chime.model.BatchUnsuspendUserResult;
import com.amazonaws.services.chime.model.BatchUpdateUserRequest;
import com.amazonaws.services.chime.model.BatchUpdateUserResult;
import com.amazonaws.services.chime.model.CreateAccountRequest;
import com.amazonaws.services.chime.model.CreateAccountResult;
import com.amazonaws.services.chime.model.DeleteAccountRequest;
import com.amazonaws.services.chime.model.DeleteAccountResult;
import com.amazonaws.services.chime.model.GetAccountRequest;
import com.amazonaws.services.chime.model.GetAccountResult;
import com.amazonaws.services.chime.model.GetAccountSettingsRequest;
import com.amazonaws.services.chime.model.GetAccountSettingsResult;
import com.amazonaws.services.chime.model.GetUserRequest;
import com.amazonaws.services.chime.model.GetUserResult;
import com.amazonaws.services.chime.model.InviteUsersRequest;
import com.amazonaws.services.chime.model.InviteUsersResult;
import com.amazonaws.services.chime.model.ListAccountsRequest;
import com.amazonaws.services.chime.model.ListAccountsResult;
import com.amazonaws.services.chime.model.ListUsersRequest;
import com.amazonaws.services.chime.model.ListUsersResult;
import com.amazonaws.services.chime.model.LogoutUserRequest;
import com.amazonaws.services.chime.model.LogoutUserResult;
import com.amazonaws.services.chime.model.ResetPersonalPINRequest;
import com.amazonaws.services.chime.model.ResetPersonalPINResult;
import com.amazonaws.services.chime.model.UpdateAccountRequest;
import com.amazonaws.services.chime.model.UpdateAccountResult;
import com.amazonaws.services.chime.model.UpdateAccountSettingsRequest;
import com.amazonaws.services.chime.model.UpdateAccountSettingsResult;
import com.amazonaws.services.chime.model.UpdateUserRequest;
import com.amazonaws.services.chime.model.UpdateUserResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonChimeAsyncClient
extends AmazonChimeClient
implements AmazonChimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonChimeAsyncClientBuilder asyncBuilder() {
        return AmazonChimeAsyncClientBuilder.standard();
    }

    AmazonChimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchSuspendUserResult> batchSuspendUserAsync(BatchSuspendUserRequest request) {
        return this.batchSuspendUserAsync(request, null);
    }

    @Override
    public Future<BatchSuspendUserResult> batchSuspendUserAsync(BatchSuspendUserRequest request, final AsyncHandler<BatchSuspendUserRequest, BatchSuspendUserResult> asyncHandler) {
        final BatchSuspendUserRequest finalRequest = (BatchSuspendUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchSuspendUserResult>(){

            @Override
            public BatchSuspendUserResult call() throws Exception {
                BatchSuspendUserResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeBatchSuspendUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchUnsuspendUserResult> batchUnsuspendUserAsync(BatchUnsuspendUserRequest request) {
        return this.batchUnsuspendUserAsync(request, null);
    }

    @Override
    public Future<BatchUnsuspendUserResult> batchUnsuspendUserAsync(BatchUnsuspendUserRequest request, final AsyncHandler<BatchUnsuspendUserRequest, BatchUnsuspendUserResult> asyncHandler) {
        final BatchUnsuspendUserRequest finalRequest = (BatchUnsuspendUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUnsuspendUserResult>(){

            @Override
            public BatchUnsuspendUserResult call() throws Exception {
                BatchUnsuspendUserResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeBatchUnsuspendUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchUpdateUserResult> batchUpdateUserAsync(BatchUpdateUserRequest request) {
        return this.batchUpdateUserAsync(request, null);
    }

    @Override
    public Future<BatchUpdateUserResult> batchUpdateUserAsync(BatchUpdateUserRequest request, final AsyncHandler<BatchUpdateUserRequest, BatchUpdateUserResult> asyncHandler) {
        final BatchUpdateUserRequest finalRequest = (BatchUpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUpdateUserResult>(){

            @Override
            public BatchUpdateUserResult call() throws Exception {
                BatchUpdateUserResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeBatchUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAccountResult> createAccountAsync(CreateAccountRequest request) {
        return this.createAccountAsync(request, null);
    }

    @Override
    public Future<CreateAccountResult> createAccountAsync(CreateAccountRequest request, final AsyncHandler<CreateAccountRequest, CreateAccountResult> asyncHandler) {
        final CreateAccountRequest finalRequest = (CreateAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAccountResult>(){

            @Override
            public CreateAccountResult call() throws Exception {
                CreateAccountResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeCreateAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAccountResult> deleteAccountAsync(DeleteAccountRequest request) {
        return this.deleteAccountAsync(request, null);
    }

    @Override
    public Future<DeleteAccountResult> deleteAccountAsync(DeleteAccountRequest request, final AsyncHandler<DeleteAccountRequest, DeleteAccountResult> asyncHandler) {
        final DeleteAccountRequest finalRequest = (DeleteAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAccountResult>(){

            @Override
            public DeleteAccountResult call() throws Exception {
                DeleteAccountResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeDeleteAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountResult> getAccountAsync(GetAccountRequest request) {
        return this.getAccountAsync(request, null);
    }

    @Override
    public Future<GetAccountResult> getAccountAsync(GetAccountRequest request, final AsyncHandler<GetAccountRequest, GetAccountResult> asyncHandler) {
        final GetAccountRequest finalRequest = (GetAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountResult>(){

            @Override
            public GetAccountResult call() throws Exception {
                GetAccountResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeGetAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request) {
        return this.getAccountSettingsAsync(request, null);
    }

    @Override
    public Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request, final AsyncHandler<GetAccountSettingsRequest, GetAccountSettingsResult> asyncHandler) {
        final GetAccountSettingsRequest finalRequest = (GetAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountSettingsResult>(){

            @Override
            public GetAccountSettingsResult call() throws Exception {
                GetAccountSettingsResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeGetAccountSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUserResult> getUserAsync(GetUserRequest request) {
        return this.getUserAsync(request, null);
    }

    @Override
    public Future<GetUserResult> getUserAsync(GetUserRequest request, final AsyncHandler<GetUserRequest, GetUserResult> asyncHandler) {
        final GetUserRequest finalRequest = (GetUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUserResult>(){

            @Override
            public GetUserResult call() throws Exception {
                GetUserResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeGetUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InviteUsersResult> inviteUsersAsync(InviteUsersRequest request) {
        return this.inviteUsersAsync(request, null);
    }

    @Override
    public Future<InviteUsersResult> inviteUsersAsync(InviteUsersRequest request, final AsyncHandler<InviteUsersRequest, InviteUsersResult> asyncHandler) {
        final InviteUsersRequest finalRequest = (InviteUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InviteUsersResult>(){

            @Override
            public InviteUsersResult call() throws Exception {
                InviteUsersResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeInviteUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccountsResult> listAccountsAsync(ListAccountsRequest request) {
        return this.listAccountsAsync(request, null);
    }

    @Override
    public Future<ListAccountsResult> listAccountsAsync(ListAccountsRequest request, final AsyncHandler<ListAccountsRequest, ListAccountsResult> asyncHandler) {
        final ListAccountsRequest finalRequest = (ListAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccountsResult>(){

            @Override
            public ListAccountsResult call() throws Exception {
                ListAccountsResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeListAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        final ListUsersRequest finalRequest = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeListUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LogoutUserResult> logoutUserAsync(LogoutUserRequest request) {
        return this.logoutUserAsync(request, null);
    }

    @Override
    public Future<LogoutUserResult> logoutUserAsync(LogoutUserRequest request, final AsyncHandler<LogoutUserRequest, LogoutUserResult> asyncHandler) {
        final LogoutUserRequest finalRequest = (LogoutUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<LogoutUserResult>(){

            @Override
            public LogoutUserResult call() throws Exception {
                LogoutUserResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeLogoutUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetPersonalPINResult> resetPersonalPINAsync(ResetPersonalPINRequest request) {
        return this.resetPersonalPINAsync(request, null);
    }

    @Override
    public Future<ResetPersonalPINResult> resetPersonalPINAsync(ResetPersonalPINRequest request, final AsyncHandler<ResetPersonalPINRequest, ResetPersonalPINResult> asyncHandler) {
        final ResetPersonalPINRequest finalRequest = (ResetPersonalPINRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResetPersonalPINResult>(){

            @Override
            public ResetPersonalPINResult call() throws Exception {
                ResetPersonalPINResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeResetPersonalPIN(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAccountResult> updateAccountAsync(UpdateAccountRequest request) {
        return this.updateAccountAsync(request, null);
    }

    @Override
    public Future<UpdateAccountResult> updateAccountAsync(UpdateAccountRequest request, final AsyncHandler<UpdateAccountRequest, UpdateAccountResult> asyncHandler) {
        final UpdateAccountRequest finalRequest = (UpdateAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAccountResult>(){

            @Override
            public UpdateAccountResult call() throws Exception {
                UpdateAccountResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeUpdateAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAccountSettingsResult> updateAccountSettingsAsync(UpdateAccountSettingsRequest request) {
        return this.updateAccountSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateAccountSettingsResult> updateAccountSettingsAsync(UpdateAccountSettingsRequest request, final AsyncHandler<UpdateAccountSettingsRequest, UpdateAccountSettingsResult> asyncHandler) {
        final UpdateAccountSettingsRequest finalRequest = (UpdateAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAccountSettingsResult>(){

            @Override
            public UpdateAccountSettingsResult call() throws Exception {
                UpdateAccountSettingsResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeUpdateAccountSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {
        return this.updateUserAsync(request, null);
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request, final AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {
        final UpdateUserRequest finalRequest = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserResult>(){

            @Override
            public UpdateUserResult call() throws Exception {
                UpdateUserResult result = null;
                try {
                    result = AmazonChimeAsyncClient.this.executeUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

