/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.trustedadvisor.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Cost optimizing aggregates for a Recommendation
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/RecommendationCostOptimizingAggregates"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RecommendationCostOptimizingAggregates implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The estimated monthly savings
     * </p>
     */
    private Double estimatedMonthlySavings;
    /**
     * <p>
     * The estimated percently monthly savings
     * </p>
     */
    private Double estimatedPercentMonthlySavings;

    /**
     * <p>
     * The estimated monthly savings
     * </p>
     * 
     * @param estimatedMonthlySavings
     *        The estimated monthly savings
     */

    public void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
        this.estimatedMonthlySavings = estimatedMonthlySavings;
    }

    /**
     * <p>
     * The estimated monthly savings
     * </p>
     * 
     * @return The estimated monthly savings
     */

    public Double getEstimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    /**
     * <p>
     * The estimated monthly savings
     * </p>
     * 
     * @param estimatedMonthlySavings
     *        The estimated monthly savings
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecommendationCostOptimizingAggregates withEstimatedMonthlySavings(Double estimatedMonthlySavings) {
        setEstimatedMonthlySavings(estimatedMonthlySavings);
        return this;
    }

    /**
     * <p>
     * The estimated percently monthly savings
     * </p>
     * 
     * @param estimatedPercentMonthlySavings
     *        The estimated percently monthly savings
     */

    public void setEstimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
        this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
    }

    /**
     * <p>
     * The estimated percently monthly savings
     * </p>
     * 
     * @return The estimated percently monthly savings
     */

    public Double getEstimatedPercentMonthlySavings() {
        return this.estimatedPercentMonthlySavings;
    }

    /**
     * <p>
     * The estimated percently monthly savings
     * </p>
     * 
     * @param estimatedPercentMonthlySavings
     *        The estimated percently monthly savings
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecommendationCostOptimizingAggregates withEstimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
        setEstimatedPercentMonthlySavings(estimatedPercentMonthlySavings);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEstimatedMonthlySavings() != null)
            sb.append("EstimatedMonthlySavings: ").append(getEstimatedMonthlySavings()).append(",");
        if (getEstimatedPercentMonthlySavings() != null)
            sb.append("EstimatedPercentMonthlySavings: ").append(getEstimatedPercentMonthlySavings());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RecommendationCostOptimizingAggregates == false)
            return false;
        RecommendationCostOptimizingAggregates other = (RecommendationCostOptimizingAggregates) obj;
        if (other.getEstimatedMonthlySavings() == null ^ this.getEstimatedMonthlySavings() == null)
            return false;
        if (other.getEstimatedMonthlySavings() != null && other.getEstimatedMonthlySavings().equals(this.getEstimatedMonthlySavings()) == false)
            return false;
        if (other.getEstimatedPercentMonthlySavings() == null ^ this.getEstimatedPercentMonthlySavings() == null)
            return false;
        if (other.getEstimatedPercentMonthlySavings() != null
                && other.getEstimatedPercentMonthlySavings().equals(this.getEstimatedPercentMonthlySavings()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEstimatedMonthlySavings() == null) ? 0 : getEstimatedMonthlySavings().hashCode());
        hashCode = prime * hashCode + ((getEstimatedPercentMonthlySavings() == null) ? 0 : getEstimatedPercentMonthlySavings().hashCode());
        return hashCode;
    }

    @Override
    public RecommendationCostOptimizingAggregates clone() {
        try {
            return (RecommendationCostOptimizingAggregates) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.trustedadvisor.model.transform.RecommendationCostOptimizingAggregatesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
