/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wellarchitected.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensVersion" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateLensVersionRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    private String lensAlias;
    /**
     * <p>
     * The version of the lens being created.
     * </p>
     */
    private String lensVersion;
    /**
     * <p>
     * Set to true if this new major lens version.
     * </p>
     */
    private Boolean isMajorVersion;

    private String clientRequestToken;

    /**
     * @param lensAlias
     */

    public void setLensAlias(String lensAlias) {
        this.lensAlias = lensAlias;
    }

    /**
     * @return
     */

    public String getLensAlias() {
        return this.lensAlias;
    }

    /**
     * @param lensAlias
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateLensVersionRequest withLensAlias(String lensAlias) {
        setLensAlias(lensAlias);
        return this;
    }

    /**
     * <p>
     * The version of the lens being created.
     * </p>
     * 
     * @param lensVersion
     *        The version of the lens being created.
     */

    public void setLensVersion(String lensVersion) {
        this.lensVersion = lensVersion;
    }

    /**
     * <p>
     * The version of the lens being created.
     * </p>
     * 
     * @return The version of the lens being created.
     */

    public String getLensVersion() {
        return this.lensVersion;
    }

    /**
     * <p>
     * The version of the lens being created.
     * </p>
     * 
     * @param lensVersion
     *        The version of the lens being created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateLensVersionRequest withLensVersion(String lensVersion) {
        setLensVersion(lensVersion);
        return this;
    }

    /**
     * <p>
     * Set to true if this new major lens version.
     * </p>
     * 
     * @param isMajorVersion
     *        Set to true if this new major lens version.
     */

    public void setIsMajorVersion(Boolean isMajorVersion) {
        this.isMajorVersion = isMajorVersion;
    }

    /**
     * <p>
     * Set to true if this new major lens version.
     * </p>
     * 
     * @return Set to true if this new major lens version.
     */

    public Boolean getIsMajorVersion() {
        return this.isMajorVersion;
    }

    /**
     * <p>
     * Set to true if this new major lens version.
     * </p>
     * 
     * @param isMajorVersion
     *        Set to true if this new major lens version.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateLensVersionRequest withIsMajorVersion(Boolean isMajorVersion) {
        setIsMajorVersion(isMajorVersion);
        return this;
    }

    /**
     * <p>
     * Set to true if this new major lens version.
     * </p>
     * 
     * @return Set to true if this new major lens version.
     */

    public Boolean isMajorVersion() {
        return this.isMajorVersion;
    }

    /**
     * @param clientRequestToken
     */

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    /**
     * @return
     */

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    /**
     * @param clientRequestToken
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateLensVersionRequest withClientRequestToken(String clientRequestToken) {
        setClientRequestToken(clientRequestToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLensAlias() != null)
            sb.append("LensAlias: ").append(getLensAlias()).append(",");
        if (getLensVersion() != null)
            sb.append("LensVersion: ").append(getLensVersion()).append(",");
        if (getIsMajorVersion() != null)
            sb.append("IsMajorVersion: ").append(getIsMajorVersion()).append(",");
        if (getClientRequestToken() != null)
            sb.append("ClientRequestToken: ").append(getClientRequestToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateLensVersionRequest == false)
            return false;
        CreateLensVersionRequest other = (CreateLensVersionRequest) obj;
        if (other.getLensAlias() == null ^ this.getLensAlias() == null)
            return false;
        if (other.getLensAlias() != null && other.getLensAlias().equals(this.getLensAlias()) == false)
            return false;
        if (other.getLensVersion() == null ^ this.getLensVersion() == null)
            return false;
        if (other.getLensVersion() != null && other.getLensVersion().equals(this.getLensVersion()) == false)
            return false;
        if (other.getIsMajorVersion() == null ^ this.getIsMajorVersion() == null)
            return false;
        if (other.getIsMajorVersion() != null && other.getIsMajorVersion().equals(this.getIsMajorVersion()) == false)
            return false;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null)
            return false;
        if (other.getClientRequestToken() != null && other.getClientRequestToken().equals(this.getClientRequestToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLensAlias() == null) ? 0 : getLensAlias().hashCode());
        hashCode = prime * hashCode + ((getLensVersion() == null) ? 0 : getLensVersion().hashCode());
        hashCode = prime * hashCode + ((getIsMajorVersion() == null) ? 0 : getIsMajorVersion().hashCode());
        hashCode = prime * hashCode + ((getClientRequestToken() == null) ? 0 : getClientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public CreateLensVersionRequest clone() {
        return (CreateLensVersionRequest) super.clone();
    }

}
