/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A structure that contains information about where Evidently is to store evaluation events for longer term storage.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ProjectDataDelivery" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ProjectDataDelivery implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     * </p>
     */
    private CloudWatchLogsDestination cloudWatchLogs;
    /**
     * <p>
     * If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket
     * prefix.
     * </p>
     */
    private S3Destination s3Destination;

    /**
     * <p>
     * If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     * </p>
     * 
     * @param cloudWatchLogs
     *        If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     */

    public void setCloudWatchLogs(CloudWatchLogsDestination cloudWatchLogs) {
        this.cloudWatchLogs = cloudWatchLogs;
    }

    /**
     * <p>
     * If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     * </p>
     * 
     * @return If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     */

    public CloudWatchLogsDestination getCloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    /**
     * <p>
     * If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     * </p>
     * 
     * @param cloudWatchLogs
     *        If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProjectDataDelivery withCloudWatchLogs(CloudWatchLogsDestination cloudWatchLogs) {
        setCloudWatchLogs(cloudWatchLogs);
        return this;
    }

    /**
     * <p>
     * If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket
     * prefix.
     * </p>
     * 
     * @param s3Destination
     *        If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and
     *        bucket prefix.
     */

    public void setS3Destination(S3Destination s3Destination) {
        this.s3Destination = s3Destination;
    }

    /**
     * <p>
     * If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket
     * prefix.
     * </p>
     * 
     * @return If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and
     *         bucket prefix.
     */

    public S3Destination getS3Destination() {
        return this.s3Destination;
    }

    /**
     * <p>
     * If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket
     * prefix.
     * </p>
     * 
     * @param s3Destination
     *        If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and
     *        bucket prefix.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProjectDataDelivery withS3Destination(S3Destination s3Destination) {
        setS3Destination(s3Destination);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCloudWatchLogs() != null)
            sb.append("CloudWatchLogs: ").append(getCloudWatchLogs()).append(",");
        if (getS3Destination() != null)
            sb.append("S3Destination: ").append(getS3Destination());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ProjectDataDelivery == false)
            return false;
        ProjectDataDelivery other = (ProjectDataDelivery) obj;
        if (other.getCloudWatchLogs() == null ^ this.getCloudWatchLogs() == null)
            return false;
        if (other.getCloudWatchLogs() != null && other.getCloudWatchLogs().equals(this.getCloudWatchLogs()) == false)
            return false;
        if (other.getS3Destination() == null ^ this.getS3Destination() == null)
            return false;
        if (other.getS3Destination() != null && other.getS3Destination().equals(this.getS3Destination()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCloudWatchLogs() == null) ? 0 : getCloudWatchLogs().hashCode());
        hashCode = prime * hashCode + ((getS3Destination() == null) ? 0 : getS3Destination().hashCode());
        return hashCode;
    }

    @Override
    public ProjectDataDelivery clone() {
        try {
            return (ProjectDataDelivery) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.cloudwatchevidently.model.transform.ProjectDataDeliveryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
