/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class GenerateDataKeyRequestMarshaller
implements Marshaller<Request<GenerateDataKeyRequest>, GenerateDataKeyRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GenerateDataKeyRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GenerateDataKeyRequest> marshall(GenerateDataKeyRequest generateDataKeyRequest) {
        if (generateDataKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateDataKeyRequest> request = new DefaultRequest<GenerateDataKeyRequest>(generateDataKeyRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.GenerateDataKey");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalMap encryptionContextMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (generateDataKeyRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(generateDataKeyRequest.getKeyId());
            }
            if (!(encryptionContextMap = (SdkInternalMap)generateDataKeyRequest.getEncryptionContext()).isEmpty() || !encryptionContextMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EncryptionContext");
                jsonGenerator.writeStartObject();
                for (Map.Entry encryptionContextMapValue : encryptionContextMap.entrySet()) {
                    if (encryptionContextMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)encryptionContextMapValue.getKey());
                    jsonGenerator.writeValue((String)encryptionContextMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (generateDataKeyRequest.getNumberOfBytes() != null) {
                jsonGenerator.writeFieldName("NumberOfBytes").writeValue(generateDataKeyRequest.getNumberOfBytes());
            }
            if (generateDataKeyRequest.getKeySpec() != null) {
                jsonGenerator.writeFieldName("KeySpec").writeValue(generateDataKeyRequest.getKeySpec());
            }
            if (!(grantTokensList = (SdkInternalList)generateDataKeyRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("GrantTokens");
                jsonGenerator.writeStartArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonGenerator.writeValue(grantTokensListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

