/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsRequest;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class AddAttributesToFindingsRequestMarshaller
implements Marshaller<Request<AddAttributesToFindingsRequest>, AddAttributesToFindingsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AddAttributesToFindingsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AddAttributesToFindingsRequest> marshall(AddAttributesToFindingsRequest addAttributesToFindingsRequest) {
        if (addAttributesToFindingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddAttributesToFindingsRequest> request = new DefaultRequest<AddAttributesToFindingsRequest>(addAttributesToFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.AddAttributesToFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Attribute> attributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> findingArnsList = addAttributesToFindingsRequest.getFindingArns();
            if (findingArnsList != null) {
                jsonGenerator.writeFieldName("findingArns");
                jsonGenerator.writeStartArray();
                for (String string : findingArnsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((attributesList = addAttributesToFindingsRequest.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

