/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.ListIndexRequest;
import com.amazonaws.services.clouddirectory.model.ObjectAttributeRange;
import com.amazonaws.services.clouddirectory.model.transform.ObjectAttributeRangeJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class ListIndexRequestMarshaller
implements Marshaller<Request<ListIndexRequest>, ListIndexRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListIndexRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListIndexRequest> marshall(ListIndexRequest listIndexRequest) {
        if (listIndexRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListIndexRequest> request = new DefaultRequest<ListIndexRequest>(listIndexRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (listIndexRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(listIndexRequest.getDirectoryArn()));
        }
        if (listIndexRequest.getConsistencyLevel() != null) {
            request.addHeader("x-amz-consistency-level", StringUtils.fromString(listIndexRequest.getConsistencyLevel()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/index/targets";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<ObjectAttributeRange> rangesOnIndexedValuesList = listIndexRequest.getRangesOnIndexedValues();
            if (rangesOnIndexedValuesList != null) {
                jsonGenerator.writeFieldName("RangesOnIndexedValues");
                jsonGenerator.writeStartArray();
                for (ObjectAttributeRange rangesOnIndexedValuesListValue : rangesOnIndexedValuesList) {
                    if (rangesOnIndexedValuesListValue == null) continue;
                    ObjectAttributeRangeJsonMarshaller.getInstance().marshall(rangesOnIndexedValuesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (listIndexRequest.getIndexReference() != null) {
                jsonGenerator.writeFieldName("IndexReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(listIndexRequest.getIndexReference(), jsonGenerator);
            }
            if (listIndexRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listIndexRequest.getMaxResults());
            }
            if (listIndexRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listIndexRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

