/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.DescribeDestinationsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeDestinationsRequestMarshaller
implements Marshaller<Request<DescribeDestinationsRequest>, DescribeDestinationsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeDestinationsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeDestinationsRequest> marshall(DescribeDestinationsRequest describeDestinationsRequest) {
        if (describeDestinationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDestinationsRequest> request = new DefaultRequest<DescribeDestinationsRequest>(describeDestinationsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.DescribeDestinations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeDestinationsRequest.getDestinationNamePrefix() != null) {
                jsonGenerator.writeFieldName("DestinationNamePrefix").writeValue(describeDestinationsRequest.getDestinationNamePrefix());
            }
            if (describeDestinationsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeDestinationsRequest.getNextToken());
            }
            if (describeDestinationsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(describeDestinationsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

