/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.DeleteSubscriptionFilterRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteSubscriptionFilterRequestMarshaller
implements Marshaller<Request<DeleteSubscriptionFilterRequest>, DeleteSubscriptionFilterRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteSubscriptionFilterRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteSubscriptionFilterRequest> marshall(DeleteSubscriptionFilterRequest deleteSubscriptionFilterRequest) {
        if (deleteSubscriptionFilterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteSubscriptionFilterRequest> request = new DefaultRequest<DeleteSubscriptionFilterRequest>(deleteSubscriptionFilterRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.DeleteSubscriptionFilter");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteSubscriptionFilterRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(deleteSubscriptionFilterRequest.getLogGroupName());
            }
            if (deleteSubscriptionFilterRequest.getFilterName() != null) {
                jsonGenerator.writeFieldName("filterName").writeValue(deleteSubscriptionFilterRequest.getFilterName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

