/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import com.amazonaws.services.workspaces.model.transform.WorkspacePropertiesJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ModifyWorkspacePropertiesRequestMarshaller
implements Marshaller<Request<ModifyWorkspacePropertiesRequest>, ModifyWorkspacePropertiesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ModifyWorkspacePropertiesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ModifyWorkspacePropertiesRequest> marshall(ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) {
        if (modifyWorkspacePropertiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyWorkspacePropertiesRequest> request = new DefaultRequest<ModifyWorkspacePropertiesRequest>(modifyWorkspacePropertiesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.ModifyWorkspaceProperties");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (modifyWorkspacePropertiesRequest.getWorkspaceId() != null) {
                jsonGenerator.writeFieldName("WorkspaceId").writeValue(modifyWorkspacePropertiesRequest.getWorkspaceId());
            }
            if (modifyWorkspacePropertiesRequest.getWorkspaceProperties() != null) {
                jsonGenerator.writeFieldName("WorkspaceProperties");
                WorkspacePropertiesJsonMarshaller.getInstance().marshall(modifyWorkspacePropertiesRequest.getWorkspaceProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

