/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeMaintenanceWindowTargetsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.MaintenanceWindowFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeMaintenanceWindowTargetsRequestMarshaller
implements Marshaller<Request<DescribeMaintenanceWindowTargetsRequest>, DescribeMaintenanceWindowTargetsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeMaintenanceWindowTargetsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeMaintenanceWindowTargetsRequest> marshall(DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) {
        if (describeMaintenanceWindowTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeMaintenanceWindowTargetsRequest> request = new DefaultRequest<DescribeMaintenanceWindowTargetsRequest>(describeMaintenanceWindowTargetsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DescribeMaintenanceWindowTargets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList filtersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeMaintenanceWindowTargetsRequest.getWindowId() != null) {
                jsonGenerator.writeFieldName("WindowId").writeValue(describeMaintenanceWindowTargetsRequest.getWindowId());
            }
            if (!(filtersList = (SdkInternalList)describeMaintenanceWindowTargetsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (MaintenanceWindowFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    MaintenanceWindowFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeMaintenanceWindowTargetsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeMaintenanceWindowTargetsRequest.getMaxResults());
            }
            if (describeMaintenanceWindowTargetsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeMaintenanceWindowTargetsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

