/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.CreateImportJobRequest;
import com.amazonaws.services.pinpoint.model.ImportJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class CreateImportJobRequestMarshaller
implements Marshaller<Request<CreateImportJobRequest>, CreateImportJobRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateImportJobRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateImportJobRequest> marshall(CreateImportJobRequest createImportJobRequest) {
        if (createImportJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateImportJobRequest> request = new DefaultRequest<CreateImportJobRequest>(createImportJobRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/apps/{application-id}/jobs/import";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", createImportJobRequest.getApplicationId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            ImportJobRequest importJobRequest = createImportJobRequest.getImportJobRequest();
            if (importJobRequest != null) {
                jsonGenerator.writeStartObject();
                if (importJobRequest.getDefineSegment() != null) {
                    jsonGenerator.writeFieldName("DefineSegment").writeValue(importJobRequest.getDefineSegment());
                }
                if (importJobRequest.getExternalId() != null) {
                    jsonGenerator.writeFieldName("ExternalId").writeValue(importJobRequest.getExternalId());
                }
                if (importJobRequest.getFormat() != null) {
                    jsonGenerator.writeFieldName("Format").writeValue(importJobRequest.getFormat());
                }
                if (importJobRequest.getRegisterEndpoints() != null) {
                    jsonGenerator.writeFieldName("RegisterEndpoints").writeValue(importJobRequest.getRegisterEndpoints());
                }
                if (importJobRequest.getRoleArn() != null) {
                    jsonGenerator.writeFieldName("RoleArn").writeValue(importJobRequest.getRoleArn());
                }
                if (importJobRequest.getS3Url() != null) {
                    jsonGenerator.writeFieldName("S3Url").writeValue(importJobRequest.getS3Url());
                }
                if (importJobRequest.getSegmentId() != null) {
                    jsonGenerator.writeFieldName("SegmentId").writeValue(importJobRequest.getSegmentId());
                }
                if (importJobRequest.getSegmentName() != null) {
                    jsonGenerator.writeFieldName("SegmentName").writeValue(importJobRequest.getSegmentName());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

