/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PatchOperation;
import com.amazonaws.services.apigateway.model.UpdateMethodResponseRequest;
import com.amazonaws.services.apigateway.model.transform.PatchOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateMethodResponseRequestMarshaller
implements Marshaller<Request<UpdateMethodResponseRequest>, UpdateMethodResponseRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateMethodResponseRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateMethodResponseRequest> marshall(UpdateMethodResponseRequest updateMethodResponseRequest) {
        if (updateMethodResponseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateMethodResponseRequest> request = new DefaultRequest<UpdateMethodResponseRequest>(updateMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", updateMethodResponseRequest.getRestApiId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "resource_id", updateMethodResponseRequest.getResourceId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "http_method", updateMethodResponseRequest.getHttpMethod());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "status_code", updateMethodResponseRequest.getStatusCode());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<PatchOperation> patchOperationsList = updateMethodResponseRequest.getPatchOperations();
            if (patchOperationsList != null) {
                jsonGenerator.writeFieldName("patchOperations");
                jsonGenerator.writeStartArray();
                for (PatchOperation patchOperationsListValue : patchOperationsList) {
                    if (patchOperationsListValue == null) continue;
                    PatchOperationJsonMarshaller.getInstance().marshall(patchOperationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

