/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.EnableSsoRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class EnableSsoRequestMarshaller
implements Marshaller<Request<EnableSsoRequest>, EnableSsoRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public EnableSsoRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<EnableSsoRequest> marshall(EnableSsoRequest enableSsoRequest) {
        if (enableSsoRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableSsoRequest> request = new DefaultRequest<EnableSsoRequest>(enableSsoRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.EnableSso");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (enableSsoRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(enableSsoRequest.getDirectoryId());
            }
            if (enableSsoRequest.getUserName() != null) {
                jsonGenerator.writeFieldName("UserName").writeValue(enableSsoRequest.getUserName());
            }
            if (enableSsoRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(enableSsoRequest.getPassword());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

