/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.FacetAttributeUpdate;
import com.amazonaws.services.clouddirectory.model.UpdateFacetRequest;
import com.amazonaws.services.clouddirectory.model.transform.FacetAttributeUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateFacetRequestMarshaller
implements Marshaller<Request<UpdateFacetRequest>, UpdateFacetRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateFacetRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateFacetRequest> marshall(UpdateFacetRequest updateFacetRequest) {
        if (updateFacetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFacetRequest> request = new DefaultRequest<UpdateFacetRequest>(updateFacetRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateFacetRequest.getSchemaArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(updateFacetRequest.getSchemaArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/facet";
        request.setResourcePath(uriResourcePath);
        try {
            List<FacetAttributeUpdate> attributeUpdatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateFacetRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateFacetRequest.getName());
            }
            if ((attributeUpdatesList = updateFacetRequest.getAttributeUpdates()) != null) {
                jsonGenerator.writeFieldName("AttributeUpdates");
                jsonGenerator.writeStartArray();
                for (FacetAttributeUpdate attributeUpdatesListValue : attributeUpdatesList) {
                    if (attributeUpdatesListValue == null) continue;
                    FacetAttributeUpdateJsonMarshaller.getInstance().marshall(attributeUpdatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateFacetRequest.getObjectType() != null) {
                jsonGenerator.writeFieldName("ObjectType").writeValue(updateFacetRequest.getObjectType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

