/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.certificatemanager.model.DomainValidation;
import java.util.List;

public class DomainValidationJsonMarshaller {
    private static DomainValidationJsonMarshaller instance;

    public void marshall(DomainValidation domainValidation, StructuredJsonGenerator jsonGenerator) {
        if (domainValidation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> validationEmailsList;
            jsonGenerator.writeStartObject();
            if (domainValidation.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(domainValidation.getDomainName());
            }
            if ((validationEmailsList = domainValidation.getValidationEmails()) != null) {
                jsonGenerator.writeFieldName("ValidationEmails");
                jsonGenerator.writeStartArray();
                for (String validationEmailsListValue : validationEmailsList) {
                    if (validationEmailsListValue == null) continue;
                    jsonGenerator.writeValue(validationEmailsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (domainValidation.getValidationDomain() != null) {
                jsonGenerator.writeFieldName("ValidationDomain").writeValue(domainValidation.getValidationDomain());
            }
            if (domainValidation.getValidationStatus() != null) {
                jsonGenerator.writeFieldName("ValidationStatus").writeValue(domainValidation.getValidationStatus());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DomainValidationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DomainValidationJsonMarshaller();
        }
        return instance;
    }
}

