/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.support.model.AddAttachmentsToSetRequest;
import com.amazonaws.services.support.model.Attachment;
import com.amazonaws.services.support.model.transform.AttachmentJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AddAttachmentsToSetRequestMarshaller
implements Marshaller<Request<AddAttachmentsToSetRequest>, AddAttachmentsToSetRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AddAttachmentsToSetRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AddAttachmentsToSetRequest> marshall(AddAttachmentsToSetRequest addAttachmentsToSetRequest) {
        if (addAttachmentsToSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddAttachmentsToSetRequest> request = new DefaultRequest<AddAttachmentsToSetRequest>(addAttachmentsToSetRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.AddAttachmentsToSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList attachmentsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addAttachmentsToSetRequest.getAttachmentSetId() != null) {
                jsonGenerator.writeFieldName("attachmentSetId").writeValue(addAttachmentsToSetRequest.getAttachmentSetId());
            }
            if (!(attachmentsList = (SdkInternalList)addAttachmentsToSetRequest.getAttachments()).isEmpty() || !attachmentsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("attachments");
                jsonGenerator.writeStartArray();
                for (Attachment attachmentsListValue : attachmentsList) {
                    if (attachmentsListValue == null) continue;
                    AttachmentJsonMarshaller.getInstance().marshall(attachmentsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

